#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Cursor                                                (cursor tag)
# =========================================================================== #
# require 'gtk_paradise/toplevel_methods/cursor.rb'
# =========================================================================== #
module Gtk

module Cursor # === Gtk::Cursor

  # ========================================================================= #
  # === Gtk::Cursor.create_cursor
  #
  # Create a cursor.
  #
  # The second argument should specify a xbm file that can be used.
  #
  #   Gtk::Cursor.create_cursor
  #
  # ========================================================================= #
  def self.create_cursor(
      main_window,
      which_xbm_to_use, # Here we require a .xbm file.
      dimension = 50
    )
    return Gdk::Pixmap.create_from_data(
      main_window.window, 
      which_xbm_to_use, 
      dimension, 
      dimension
    )
  end

end

# =========================================================================== #
# === Gtk.create_cursor
# =========================================================================== #
def self.create_cursor(
    main_window,
    which_xbm_to_use,
    dimension = 50
  )
  Gtk::Cursor.create_cursor(
    main_window,
    which_xbm_to_use,
    dimension
  )
end

# =========================================================================== #
# === Gtk.hand_cursor
#
# Note that this method is experimental - it may be removed at a later
# moment in time. The idea behind this method is to make it easier
# to grab a different cursor in ruby-gtk applications.
#
# Since as of January 2022 this method will default to ruby-gtk3, which
# is indicated by the symbol :hand2. The old ruby-gtk2 variant was to
# use Gdk::Cursor::HAND2, which became Gdk::CursorType::HAND2 in
# ruby-gtk3 (or the symbol).
# =========================================================================== #
def self.hand_cursor(
    use_this_cursor = :hand2 # Or Gdk::Cursor::HAND2 for ruby-gtk2.
  )
  Gdk::Cursor.new(use_this_cursor)
end

# =========================================================================== #
# === Gtk.regular_cursor
# =========================================================================== #
def self.regular_cursor
  Gdk::Cursor.new(Gdk::Cursor::XTERM)
end

end

if __FILE__ == $PROGRAM_NAME
  require 'gtk3'
  alias e puts
  e Gtk.hand_cursor.class  
end