#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::DemoOfLabels
#
# This widget will demonstrate what can be done with Gtk::Labels.
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class DemoOfLabels < ::Gtk::VBox # === Gtk::DemoOfLabels

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === DemoOfLabels::MAX_HEIGHT
  # ========================================================================= #
  MAX_HEIGHT = 380

  # ========================================================================= #
  # === DemoOfLabels::MAX_WIDTH
  # ========================================================================= #
  MAX_WIDTH  = 700

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    reset
    set_font_size(18)
    set_size_request(MAX_HEIGHT, MAX_WIDTH)
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    label1 = gtk_label('_Not Use Mnemonic')
    label1.selectable = true

    label2 = gtk_label('_Use Mnemonic', true)
    label3 = gtk_label.set_markup(
      %Q[<markup><span size="xx-large" weight="bold" foreground="blue">
      <u>Ruby-GNOME2</u></span> is <span foreground="red" size="x-large">\
      <i>cool</i></span>!</markup>], true
    )

    label4 = gtk_label.set_markup(
      %Q[<span foreground="#999900">_Not Use Mnemonic</span>]
    )

    label5 = gtk_label.set_markup(
      %Q[<span foreground="#009999">_Use Mnemonic</span>], true
    )

    label6 = gtk_label(
      'Some <a href="http://en.wikipedia.org/wiki/Text"
      title="plain text">text</a> may be marked up
      as hyperlinks'
    )
    label6.use_markup = true

    # ======================================================================= #
    # Put these Labels into a VBox:
    # ======================================================================= #
    box = gtk_vbox
    box.add_these(
      label1, label2, label3,
      label4, label5, label6
    )
    box.show_all
    #label1.select_region(6, 10) # Select some parts.
    add(box)
  end

  # ========================================================================= #
  # === recommended_total_width?
  # ========================================================================= #
  def recommended_total_width?
    MAX_WIDTH
  end

  # ========================================================================= #
  # === recommended_total_height?
  # ========================================================================= #
  def recommended_total_height?
    MAX_HEIGHT
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  demo_of_labels = Gtk::DemoOfLabels.new
  r = ::Gtk::Runner.new(
    demo_of_labels.recommended_total_width?,
    demo_of_labels.recommended_total_height?,
    :tabble_picture,
    'Show some labels',4 
  )
  r << demo_of_labels
  r.set_background_colour :white
  r.enable_quick_exit
  r.top_left_then_show_all
  r.run
end # gtk_demo_of_labels