#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ExpanderExample
#
# Usage example:
#
#   Gtk::ExpanderExample.new
#
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/paned_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class ExpanderExample < ::Gtk::HBox # === Gtk::ExpanderExample

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    set_size_request(250, 250)
    button = gtk_button('Hide this button.')
    expander = gtk_expanded_expander('Expander Sample') {{ widget: button }} # Add the button into the expander.
    button.on_clicked { expander.do_collapse }
    add(expander).show_all.signal_connect(:destroy) { Gtk.main_quit }
  end

  # ========================================================================= #
  # === width?
  #
  # The preferred (hardcoded) width. We assume oldschool desktop-computers
  # here.
  # ========================================================================= #
  def width?
    600
  end

  # ========================================================================= #
  # === Gtk::ExpanderExample[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  expander_example = Gtk::ExpanderExample.new
  r = Gtk.runner(title: 'Expander Example', width: 120, height: 50)
  r << expander_example
  r.enable_quick_exit
  r.top_left_then_run
end # expanderexample