#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::FotoLister
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class FotoLister < ::Gtk::VBox # === Gtk::FotoLister

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === IMG_DIRECTORY
  #
  # Specify the base-directory to list images.
  # ========================================================================= #
  IMG_DIRECTORY = '/home/x/data/images/fotos/roebe/'

  # ========================================================================= #
  # === ENCODING_UTF
  # ========================================================================= #
  ENCODING_UTF = 'UTF-8'

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'foto lister'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 750

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 820

  # ========================================================================= #
  # === N
  # ========================================================================= #
  N = "\n"

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(TITLE)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @base_dir
    # ======================================================================= #
    @base_dir = IMG_DIRECTORY
    # ======================================================================= #
    # === @array_fotos
    # ======================================================================= #
    @array_fotos = Dir[@base_dir+'*'] # Will be in ISO Encoding.
    increase_font_size
  end

  # ========================================================================= #
  # === FotoLister.width?
  # ========================================================================= #
  def self.width?
    WIDTH
  end

  # ========================================================================= #
  # === FotoLister.height?
  # ========================================================================= #
  def self.height?
    HEIGHT
  end

  # ========================================================================= #
  # === create_buttons                                          (buttons tag)
  # ========================================================================= #
  def create_buttons
    # ======================================================================= #
    # === @button_update
    # ======================================================================= #
    @button_update = button('_Update and Change')
    @button_update.on_clicked {
      update_combo_box
      @combo_box.active = @array_fotos.size.sample
    }
  end

  # ========================================================================= #
  # === update_combo_box
  # ========================================================================= #
  def update_combo_box
    @combo_box.model.clear
    e 'Working on '+@array_fotos.size.to_s+' images next.'
    @array_fotos.each { |item|
      begin
        # item = item.encode(ENCODING_UTF)
        image = GdkPixbuf::Pixbuf.new(file: item, width: 200, height: 200)
      rescue Gdk::PixbufError 
        e 'GdkPixbuf::Pixbuf - can not load file: '+sfile(item)
      rescue GLib::FileError => error
        e 'Strange error - we could not find this file: '+
          simp(item.to_s)
        e File.exist? item
        pp error
      end
      iter = @list_store.append
      iter[0] = image
      iter[1] = item.split('/').last # .gsub(/\.png/,'')
    }
    @combo_box.wrap_width = 2
  end

  # ========================================================================= #
  # === create_combo_box
  # ========================================================================= #
  def create_combo_box
    @list_store = gtk_list_store(GdkPixbuf::Pixbuf, String)
    @combo_box = gtk_combo_box(@list_store)
    @combo_box.add_tearoffs = true

    update_combo_box
    @combo_box.active = 3

    renderer = gtk_cell_renderer_pixbuf
    @combo_box.pack_start(renderer, false)
    @combo_box.set_attributes(renderer, pixbuf: 0)

    renderer = gtk_cell_renderer_text
    @combo_box.pack_start(renderer, true)
    @combo_box.set_attributes(renderer, text: 1)
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    minimal(
      gtk_label('Reading data from the directory '+@base_dir)
    )
    add(@combo_box)
    add(@button_update)
  end

  # ======================================================================== #
  # === create_skeleton
  # ======================================================================== #
  def create_skeleton
    create_combo_box
    create_buttons
  end

  # ======================================================================== #
  # === run
  # ======================================================================== #
  def run
    create_skeleton
    connect_skeleton
    show_all
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  x = Gtk::FotoLister.new
  r = Gtk.run('80%','72%',
    ENV['IMG'].to_s+'/STD/FAECHER.png')
  r.add_shortcut(1, 'focus_on(@entry_pid_number)', :alt)
  r << x
  r.modify_background :normal, :grey
  r.automatic
  r.enable_quick_exit
  r.top_left_then_run
end # foto_lister