#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === MsWin::MsSysControl
#
# This class serves to be some kind of syscontrol for windows. As of
# 2020 it is a bit outdated; I am not sure whether I will update it
# but just in case that I may, the code is available here still.
#
# It is essentially a fancified Gtk::Notebook.
#
# Note that it may require GtkVim.
# =========================================================================== #
# Todo:
#
#   - also remote start things on windows machine.
#
# =========================================================================== #
# require 'gtk_paradise/widgets/mswin/ms_sys_control.rb'
# =========================================================================== #
require 'gtk_paradise/widgets/gtk2/mswin/constants.rb'

module Gtk

module MsWin

require 'gtk_paradise/run'

class MsSysControl < ::Gtk::Runner # Directly subclass from Gtk::Runner.

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule
  
  require 'gtk_paradise/classes/gtk2/mswin/sys_cmd_button.rb'
  require 'gtk_paradise/widgets/gtk2/notebook_tab_with_icon.rb'

  require 'colours'
  include ::Colours

  include ::Gtk::Colours

  # ====================================================================== #
  # === initialize
  # ====================================================================== #
  def initialize
    super(
      WIDTH,
      HEIGHT,
      :tabble,
      'MS Sys Control',DEFAULT_PADDING
    )
    modify_background(:normal, :azure)
    determine_the_desired_width_and_height
    reset
    create_skeleton
    connect_skeleton
  end

  # ====================================================================== #
  # === reset
  # ====================================================================== #
  def reset
    # ==================================================================== #
    # === @array_buttons
    #
    # This array contains all our buttons.
    # ==================================================================== #
    @array_buttons = []
    increase_font_size
  end

  # ====================================================================== #
  # === determine_the_desired_width_and_height
  # ====================================================================== #
  def determine_the_desired_width_and_height(
      width = WIDTH, height = HEIGHT
    )
    set_size_request(width, height)
  end

  # ====================================================================== #
  # === create_skeleton
  # ====================================================================== #
  def create_skeleton
    create_entries
    create_buttons
    create_comboboxes
    create_notebook # contains all our tabs.
    create_all_tabs # Create the tabs here.
  end

  # ====================================================================== #
  # === notebook
  # ====================================================================== #
  def notebook
    @notebook
  end

  # ====================================================================== #
  # === create_comboboxes
  # ====================================================================== #
  def create_comboboxes
    @combo_box = gtk_combo_box_entry
    @combo_box.add_tearoffs = true
    @combo_box.append_text('Start Game GLEST')
    @combo_box.append_text('Start Game xxx')
    @combo_box.active = 0
    @combo_box.signal_connect(:event) { |widget, event|
      case event.event_type # event.event_type.name
      when Gdk::Event::BUTTON_PRESS
        e "Starting game #{@combo_box.active_text} next."
      end
    }
  end
  
  # ====================================================================== #
  # === do_action
  # ====================================================================== #
  def do_action(which_action)
    case which_action
    when :mingw_login
      e 'Sourcing several Ming Login stuff:'
      e '1) aliasrc'
      rc_dir = ENV['LINUX'].to_s+'/RC_FILES/'
      MyLogger.write_what_into('. '+rc_dir+'aliasrc',
        PROFILE_FILE,'a+'
      )
      e '1) colourc'
      MyLogger.write_what_into('. '+rc_dir+'colourc',
        PROFILE_FILE,'a+'
      )
      e '1) ps1_rc'
      MyLogger.write_what_into('. '+rc_dir+'ps1_rc',
        PROFILE_FILE,'a+'
      )
    end
  end

  # ====================================================================== #
  # === win_copy
  #
  # Copies a file from someplace to a windows location.
  # ====================================================================== #
  def win_copy(this_action = :hosts_file)
    case this_action.to_sym
    when :hosts_file, :default
      require 'fileutils'
      # cat /home/x/DATA/PC/MS/NETWORKING/win_hosts
      source_file = '/home/x/DATA/PC/MS/NETWORKING/win_hosts'
      if File.exists? source_file
        e 'Since our target file exists, we will now copy the '\
          'Windows hosts file to '+TARGET_FILE_WINDOWS_HOSTS_FILE
        FileUtils.copy_file(source_file, TARGET_FILE_WINDOWS_HOSTS_FILE)
      else
        e 'Trying to copy `'+source_file+'` to '+TARGET_FILE_WINDOWS_HOSTS_FILE+
          ' but `'+source_file+'` does not exist.'
      end
    end
  end

  # ====================================================================== #
  # === create_fresh_install_tab
  #
  # This creates our fourth tab. 4 tab.
  # ====================================================================== #
  def create_fresh_install_tab
    @button_copy_hosts_file = gtk_button(
      'Copy Win hosts file to '+TARGET_FILE_WINDOWS_HOSTS_FILE
    )
    @button_copy_hosts_file.on_clicked { win_copy(:hosts_file) }

    @button_source_mingw_login = gtk_button('Enable Source Mingw Login')
    @button_source_mingw_login.on_clicked {
      do_action(:mingw_login)
    }
    
    hbox = create_paned_vbox(
      gtk_label('This tab is used for fresh windows installs, 
      so that I dont have to manually copy the stuff to windows.'),
      @button_copy_hosts_file,
      @button_source_mingw_login
    )
    tab = Gtk::NotebookTabWithIcon.new('alert', 'FreshInstall Actions')
    Gtk.set_tooltip_for(tab, 'Freshinstall actions grouped together.')
    @notebook.append_page_menu( hbox, tab)
    @notebook.set_tab_reorderable(hbox, true)
  end

  # ====================================================================== #
  # === create_editor_tab
  #
  # This tab is currently not in use.
  #
  # 5 tab. 5 tag.
  # ====================================================================== #
  def create_editor_tab
    require 'editors/vim/gtk_vim.rb'
    hbox = Gtk.create_paned_vbox(GtkVim.new)
    tab = Gtk::NotebookTabWithIcon.new(:alert, 'Editor')
    Gtk.set_tooltip_for(tab, 'Ruby-VIM Editor.')
    @notebook.append_page_menu( hbox, tab)
    @notebook.set_tab_reorderable(hbox, true)
  end

  # ====================================================================== #
  # === create_tab_ms_apps_starter
  #
  # This tabs contains stuff which you can "click-on" to launch windows
  # Syscontrol things like taskmgr and so on. Contains win-native apps.
  # The first tab, first tag. 1 tag. 1 tab.
  # ====================================================================== #
  def create_tab_ms_apps_starter
    hbox = create_paned_vbox( 
      Gtk.create_paned_hbox(
        SysCmdButton.new('ciadv.msc',self,''),
        SysCmdButton.new('cleanmgr.exe',self,''),
        SysCmdButton.new('clipbrd',self,'Clipboard'),
        SysCmdButton.new('start cmd',self,'Start the windows cmd shell'),
        SysCmdButton.new('start cygwin.bat',self,'Start Cygwin'),
        SysCmdButton.new('sysedit',self,'Allows you to edit your '+
         'System settings.')
      ),
      Gtk.create_paned_hbox(
        SysCmdButton.new('compmgmt.msc',self,''),
        SysCmdButton.new('services.msc',self,''),
        SysCmdButton.new('progman.exe',self,''),
        SysCmdButton.new('regedit.exe',self,'Registry Editor'),
        SysCmdButton.new('osk',self,'Eine tastaturhilfe'),
        SysCmdButton.new('magnify',self,'Lupe')
      ),
      Gtk.create_paned_hbox(
        SysCmdButton.new('winchat.exe',self,'Chat on Windowss'),
        SysCmdButton.new('sigverif',self,''),
        SysCmdButton.new('shrpubw',self,''),
        SysCmdButton.new('perfmon.msc',self,
           GLib.convert('Datenträger bereinigen', 'utf-8', 'iso-8859-1')),
        SysCmdButton.new('dfrg.msc',self,''),
        SysCmdButton.new('devmgmt.msc',self,'')
      ),
      Gtk.create_paned_hbox( 
        SysCmdButton.new('drwtsn32',self,'Dr Watson'),
        SysCmdButton.new('msconfig',self,''),
        SysCmdButton.new('dxdiag',self,'DirectX Configuration'),
        SysCmdButton.new('conf',self,'Konferenz Meeting'),
        SysCmdButton.new('diskmgmt.msc',self,'Datenträgerzuweisung (wichtig)'),
        SysCmdButton.new('fsmgmt.msc',self,'zeigt einem die freigegebenen Ordner an')
      ),
      # Add "calc" and "taskmgr" next.
      Gtk.create_paned_hbox( 
        SysCmdButton.new('calc',self,'StandardWindows Calculator'),
        SysCmdButton.new('taskmgr',self,'Manages your Tasks here.')
      ),
      Gtk.create_paned_hbox( 
        SysCmdButton.new('control',self,'Systemsteuerung (wichtig)',nil,nil,'orange'),
        SysCmdButton.new('ntmsoprg.msc',self,
           GLib.convert('Übersicht über Wechselmedien', 'utf-8', 'iso-8859-1')
         )
      )
    )
    vbox = Gtk.create_paned_vbox(hbox, @hbox_with_entries)

    tab = Gtk::NotebookTabWithIcon.new(:shield, 'MS App Starter')
    Gtk.set_tooltip_for(tab, 'MS App Starter.')
    @notebook.append_page_menu( vbox, tab)
    @notebook.set_tab_reorderable(vbox, true)
  end
  
  # ====================================================================== #
  # === create_tabble_tab
  #
  # Create the Tabble tab.
  # ====================================================================== #
  def create_tabble_tab
    require 'gtk_paradise/requires/require_the_tabble_project.rb'
    tabble = ::Gtk::Tabble.run
    tab = Gtk::NotebookTabWithIcon.new('Tabble', 'Tabble')
    Gtk.set_tooltip_for(tab,
      'This tab groups together several smaller programs.')
    @notebook.append_page_menu( tabble, tab)
    @notebook.set_tab_reorderable(tabble, true)
  end

  # ====================================================================== #
  # === create_windows_apps
  #
  # Our second tab. 2 tab.
  # ====================================================================== #
  def create_windows_apps
    @entry_current_command = gtk_entry
    hbox = create_paned_vbox( 
      # Add: GIMP, spybot and mplayer.
      Gtk.create_paned_hbox(
        add_sys_button('/Programme/GIMP-2.0/bin/gimp-2.4.exe','Gimp',
        'IMG/GIMP/gimp-2.4.0.exe'),
        add_sys_button('/Programme/Spybot/Spybot.exe','Spybot',
        'REGISTRY/Spybotsd14.exe'),
        add_sys_button('/Programme/MPlayer-1.0rc1-gui/gmplayer.exe','Mplayer GUI',
        'VID/MPlayer-1.0rc1-gui.zip')
      ),
      # Add virtualdub, irfanview, and contextfree.
      Gtk.create_paned_hbox(
        add_sys_button('/Programme/Vdub-1.6.19/VirtualDub.exe','Virtual Dub',
        'VID/VDUB/VirtualDub-1.6.19.zip'),
        add_sys_button('/Programme/IrfanView/i_view32.exe','Irfan View - Image Editor',
        'IMG/IrfanView/IrfanView-4.1.0.exe'),
        add_sys_button('/Programme/OzoneSoft/ContextFree/ContextFree.exe','Context Free',
        'IMG/ContextFreeInstall2.0beta.exe')
      ),
      # Add Inkscape, winscp and openoffice.
      Gtk.create_paned_hbox(
        add_sys_button('/Programme/Inkscape/inkscape.exe','Inkscape Graphical Application',
        'IMG/Inkscape-0.45.1-1.win32.exe'),
        add_sys_button('/Programme/WinSCP/WinSCP.exe','WinSCP',
        'NETWORKING/WinSCP-4.0.2.exe'),
        add_sys_button('/Programme/Openoffice/program/soffice.exe','OpenOffice.org',
        'OPENOFFICE/OOo_2.3.0_Win32Intel_install_wJRE_de.exe')
      ),
      Gtk.create_paned_hbox(
        add_sys_button('/Programme/Notepad++/notepad++.exe','Notepad',
        'EDITOR/NotepadPlusPlus-4.1.2.exe'),
        add_sys_button('/Programme/DVD Decrypter/DVDDecrypter.exe','DVD Decrypter',
        'VID/DVD_Decrypter_3.5.4.0.exe'),
        add_sys_button('/Programme/AutoGK/AutoGK.exe','AutoGK',
        'VID/GordianKnot/AutoGordianKnot-1.25.exe')
      ),
      Gtk.create_paned_hbox(
        add_sys_button('/Programme/Audacity/audacity.exe','Audacity',
        'AUD/Audacity-1.3.3.exe'),
        add_sys_button('/Programme/Mplayer/gmplayer.exe','GMplayer',
        'VID/MPlayer-1.0rc1-gui.zip'),
        add_sys_button('/Programme/X-Chat 2/xchat.exe','',
        'IRC/Silverex-xchat-2.8.0-1.exe')
      ),
      Gtk.create_paned_hbox(entry_current_command, @button_update, @combo_box)
    )
    
    tab = Gtk::NotebookTabWithIcon.new('alert','Other Applications')
    Gtk.set_tooltip_for(tab, 'This collects some addons for Windows.')
    @notebook.append_page_menu(hbox, tab)
    @notebook.set_tab_reorderable(hbox, true)
  end

  # ====================================================================== #
  # === create_win_api
  #
  # 3rd tab third tab 3 tag.
  # ====================================================================== #
  def create_win_api
    # ==================================================================== #
    # === @button_logout
    #
    # This button allows us to log out from windows.
    # ==================================================================== #
    @button_logout = gtk_button('Logout from Windows (via "logout")')
    @button_logout.on_clicked {
      esystem 'logout'
    }
    @button_logout.make_bold
    
    icon = Gtk::NotebookTabWithIcon.new('shield','WinAPI Specifics')
    widget = Gtk.create_paned_vbox(
      gtk_label('
        hier kommt winapi spezifischjes 
        zeug rein... also API control zeug. '
      ), 
      Gtk::NotebookTabWithIcon.new('shield',
        'hier kommt winapi spezifischjes '+
        'Zeug rein... also API control zeug'
      ),
        @button_logout
    )
    Gtk.set_tooltip_for(icon, 
      'This tab groups together some winAPI specific stuff.')
    @notebook.append_page_menu(widget, icon)
    @notebook.set_tab_reorderable(widget, true)
  end

  # ====================================================================== #
  # === add_sys_button
  # ====================================================================== #
  def add_sys_button(new_location, title, real_location)
    button = SysCmdButton.new(new_location, self, '',
      @entry_current_command,nil, 'cadetblue',real_location
    )
    @array_buttons << button
    return button
  end
  
  # ====================================================================== #
  # === create_notebook                                     (notebook tag)
  #
  # Contains stuff for our notebook widget.
  # ====================================================================== #
  def create_notebook
    @array_notebook_tab = [] 
    @notebook = gtk_notebook
    @notebook.set_scrollable(true)
  end
  
  # ====================================================================== #
  # === notebook_set_page
  # ====================================================================== #
  def notebook_set_page(index = 0)
    @notebook.set_page(index)
  end

  # ====================================================================== #
  # === run_sys_command
  # ====================================================================== #
  def run_sys_command(this_command = @entry_command_to_run.text)
    @entry_command_to_run.set_text(this_command)
    MsSysControl.run_sys_command(this_command)
  end

  # ====================================================================== #
  # === create_entries
  #
  # Contains all our entries.
  # ====================================================================== #
  def create_entries
    @hbox_with_entries = gtk_hbox
    
    @entry_command_to_run = gtk_entry
    @entry_command_to_run.on_key_press_event { |widget, event|
      run_sys_command if Gdk::Keyval.to_name(event.keyval) == 'Return'
    }
    @entry_command_to_run.set_size_request(260, 24)
    @entry_command_to_run.on_button_press_event { |widget, event|
      @entry_command_to_run.set_focus( true ) 
    }
    @entry_command_to_run.set_activates_default(true) 
  end
  
  # ====================================================================== #
  # === create_buttons
  #
  # buttons tag.
  # ====================================================================== #
  def create_buttons
    @button_run_sys_command = gtk_button('_Run Sys Command')
    @button_update = gtk_button('_Update')
    # @button_run_sys_command.set_size_request(50, 25)
    @button_run_sys_command.on_clicked { |widget, event|
      run_sys_command
    }
    @button_update.on_clicked { |widget, event|
      e 'right now not doing much... update_all'
      @array_buttons.each { |button| pp button }
    }
  end

  # ====================================================================== #
  # === hookup_accel_group
  #
  # Register our accel keys.
  # ====================================================================== #
  def hookup_accel_group
    @accel_group = Gtk::AccelGroup.new
    add_accel_group( @accel_group ) 

    @accel_group.connect( Gdk::Keyval::GDK_KEY_1, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(0) } 
    @accel_group.connect( Gdk::Keyval::GDK_KEY_2, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(1) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_3, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(2) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_4, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(3) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_5, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(4) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_6, 
      Gdk::Window::CONTROL_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(5) }

    @accel_group.connect( Gdk::Keyval::GDK_KEY_1, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(0) } 
    @accel_group.connect( Gdk::Keyval::GDK_KEY_2, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(1) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_3, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(2) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_4, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(3) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_5, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(4) }
    @accel_group.connect( Gdk::Keyval::GDK_KEY_6, 
      Gdk::Window::MOD1_MASK, Gtk::ACCEL_VISIBLE) { notebook_set_page(5) }
  end

  # ====================================================================== #
  # === connect_skeleton
  #
  # Should contain ONLY the @notebook
  # ====================================================================== #
  def connect_skeleton
    hookup_accel_group
    @hbox_with_entries.pack_minimal gtk_image(IMG+'CARTOONS/SMALL_CAT.png'),5
    @hbox_with_entries.pack_start @entry_command_to_run,true,false,1
    @hbox_with_entries.pack_start @button_run_sys_command,true,false,1
    add(@notebook) # now add the notebook
    show_all
  end

  # ====================================================================== #
  # === start
  # ====================================================================== #
  def start
    Gtk.main
  end

  # ====================================================================== #
  #
  # ====================================================================== #
  def self.e(i = '')
    puts i
  end

  # ====================================================================== #
  # === run_sys_command
  #
  # Wrapper to run a system command in a thread.
  # MsSysControl.run_sys_command
  # ====================================================================== #
  def self.run_sys_command(
      this_command = @entry_command_to_run.text
    )
    e this_command
    Thread.new { system(this_command) }  
  end

  # ====================================================================== #
  # === entry_current_command?
  # ====================================================================== #
  def entry_current_command?
    @entry_current_command
  end; alias entry_current_command entry_current_command? # === entry_current_command

  # ====================================================================== #
  # === accel_group
  # ====================================================================== #
  def accel_group
    @accel_group
  end

  # ====================================================================== #
  # === create_all_tabs                                         (tabs tag)
  #
  # Bundle the tabs together.
  # ====================================================================== #
  def create_all_tabs
    create_tab_ms_apps_starter # 1. tab
    create_windows_apps        # 2. tab
    create_win_api             # 3. tab
    # create_tabble_tab        # 4. tab
    create_fresh_install_tab   # 5. tab
    #create_editor_tab          # 6. tab
  end

end; end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::MsWin::MsSysControl.new.start
end # mssys