#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::PanedExample
#
# Usage example:
#
#   Gtk::PanedExample.new
#
# =========================================================================== #
# require 'gtk_paradise/classes/paned_example.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class PanedExample < ::Gtk::HBox # === Gtk::PanedExample

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    increase_font_size
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    @width = 1200
    # ======================================================================= #
    # === @paned_border_width
    # ======================================================================= #
    @paned_border_width = 20
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    vpaned = gtk_vpaned(
      gtk_label('VPaned, Label1'),
      gtk_label('VPaned, Label2')
    )
    vpaned.set_border_width(@paned_border_width)
    vpaned.set_size_request(850, 650)
    vpaned.set_position(500)

    hpaned = gtk_hpaned(
      gtk_label('Hpaned Label 1'),
      vpaned
    )
    hpaned.set_border_width(@paned_border_width)
    hpaned.set_size_request(width?, height?)

    add(hpaned)
  end

  # ========================================================================= #
  # === height?
  # ========================================================================= #
  def height?
    600
  end

  # ========================================================================= #
  # === Gtk::PanedExample[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  paned_example = ::Gtk::PanedExample.new
  r = Gtk.run(title: 'Paned Example')
  r << paned_example
  r.enable_quick_exit
  r.top_left_then_run
end # panedexample