#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::RandomImage
#
# The purpose of this class is to randomly select an image from a given
# local directory. It is not that useful, but it can be used for
# demonstration-purposes.
#
# The class is deliberately working only on random images so that we
# don't have to think about how to select an image specifically, for
# the time being. At a later time this may change.
# =========================================================================== #
# Original creation date of this file: 09.12.2005
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/image/random_image.rb
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class RandomImage < VBox # === Gtk::RandomImage

  require 'gtk_paradise/widgets/shared_code/random_image/random_image_module.rb'
  include ::Gtk::RandomImageModule

  # ========================================================================= #
  # === Gtk::RandomImage.run
  # ========================================================================= #
  def self.run
    ::Gtk::RandomImageModule.run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::RandomImage.run
end # randomimage