#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SliderChangingButton
#
# Usage example:
#
#   Gtk::SliderChangingButton.new
#
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/slider_changing_button.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class SliderChangingButton < ::Gtk::HBox # === Gtk::SliderChangingButton

  include ::Colours
  include ::Colours::E

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = nil,
      run_already           = true
    )
    super()
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title = 'Slider Changing Button'
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(600)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    set_size_request(250, 250)
    @main_entry = gtk_entry

    # ======================================================================= #
    # First, enable the scale-button.
    # ======================================================================= #
    scale_button = gtk_scale_button
    scale_button.set_icons(
      %w(
        gtk-goto-bottom gtk-goto-top gtk-execute
      )
    )
    scale_button.on_value_changed { |widget, value|
      @main_entry.set_text(value.to_s)
    }
    hscale = gtk_hscale(n_digits: 0)
    hscale.adjustment.step_increment = 2
    hscale.on_value_changed { |hscale_widget, value|
      value_from_the_hscale_widget = hscale_widget.value.to_s
      e sfancy(value_from_the_hscale_widget)
      @main_entry.set_text(value_from_the_hscale_widget)
    }

    hscale.set_range(0, 50)
    hscale.set_size_request(80, -1)

    minimal(@main_entry, 2)
    minimal(hscale, 2)
    show_all
  end

  # ========================================================================= #
  # === Gtk::SliderChangingButton[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  slider_changing_button = Gtk::SliderChangingButton.new
  r = Gtk.run
  r << slider_changing_button
  r.set_default_size(500, 500)
  r.enable_quick_exit
  r.top_left_then_run
end # slider_changing_button