#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This features a table example, in gtk (gtk2 specifically for the time
# being).
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class TableExample < ::Gtk::Frame

  begin
    require 'colours/e'
    include ::Colours::E
  rescue LoadError; end

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  ::Gtk.set_font 'DejaVu Sans Mono 22'

  # ========================================================================= #
  # === TITLE_FOR_THE_GTK_FRAME
  # ========================================================================= #
  TITLE_FOR_THE_GTK_FRAME = ' Table example '

  # ========================================================================= #
  # === BORDER_WIDTH
  # ========================================================================= #
  BORDER_WIDTH = 8

  # ========================================================================= #
  # === USE_N_BUTTONS
  #
  # This constant specifies how many buttons we are to use for this example.
  # These buttons will be located in the first row of the gtk-table.
  #
  # Note that some layout-related properties may change as a consequence
  # of this, e. g. where the quit-button is displayed.
  # ========================================================================= #
  USE_N_BUTTONS = 8

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(TITLE_FOR_THE_GTK_FRAME)
    reset
    make_bold
    upon_delete_event_quit_the_application
    set_border_width(BORDER_WIDTH)
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, inspect]
  end

  # ========================================================================= #
  # === title?
  # ========================================================================= #
  def title?
    TITLE_FOR_THE_GTK_FRAME
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    # ======================================================================= #
    # Create a 7x1 table:
    # ======================================================================= #
    @table = ::Gtk::Table.new(2, USE_N_BUTTONS - 1, true)
    @v_box = gtk_vbox
    @v_box.add(@table)
    (1 .. (USE_N_BUTTONS)).to_a.each { |i|
      button = gtk_button("button #{i}")
      button.on_clicked {
        e "Button #{i} was pressed."
      }
      # ===================================================================== #
      # Insert button 1 into the upper left quadrant of the table,
      # and button 2 into the upper right quadrant of the table.
      # ===================================================================== #
      @table.attach_defaults(button, i - 1, i, 0, 1)
    }
    button = gtk_button('_Quit')
    button.on_clicked { Gtk.main_quit }
    # ======================================================================= #
    # Insert the quit button into the both lower quadrants of the table.
    # ======================================================================= #
    @table.attach_defaults(button, 7, 8, 1, 2)
    @table.attach_defaults(
      gtk_button('a "small" button'), 6, 7, 1, 2
    )
    scrolled_window = gtk_scrolled_window(@v_box) { :always }
    scrolled_window.set_size_request(1200, 500)
    add(scrolled_window)
    show_all
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    connect_skeleton
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  table_example = Gtk::TableExample.new
  r = Gtk.run(600, 220)
  r.enable_quick_exit
  r << table_example
  r.top_left_then_run
end # $RUBY_GTK/table_example.rb