#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::InputValidator
# =========================================================================== #
# require 'gtk_paradise/classes/timer_window/input_validator.rb'
# =========================================================================== #
module Gtk

module TimerWindow

class InputValidator

  # ========================================================================= #
  # === Gtk::TimerWindow::InputValidator.validate
  # ========================================================================= #
  def self.validate(*args)
    args.each { |arg|
      unless validate_integer arg
        return false
      end
    }
    true
  end

  # ========================================================================= #
  # === Gtk::TimerWindow::InputValidator.validate_integer
  #
  # This method will determine whether the given input is an Integer.
  # If it is then true will be returned.
  # ========================================================================= #
  def self.validate_integer(i)
    return true if i.to_i > 0
    false
  end

end; end; end