#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::Timer
# =========================================================================== #
# require 'gtk_paradise/classes/gtk2/timer_window/timer.rb'
# =========================================================================== #
module Gtk

module TimerWindow

class Timer
  
  # ========================================================================= #
  # === initialize
  #
  # Initialize thee timer informing how much time it must take in SECONDS.
  # ========================================================================= #
  def initialize(i = 9)
    @duration = i
    reset
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @current_time
    # ======================================================================= #
    @current_time = Time.now.to_i
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    reset
    @future = @current_time + @duration
    loop {
      @current_time = Time.now.to_i
      TimerWindow.instance.panel.progress_bar.fraction = fraction
      TimerWindow.instance.panel.progress_bar.text = "Remaining time: #{remaining_time?}"
      sleep 1
      break if @current_time > @future
    }
  end

  # ========================================================================= #
  # === difference
  # ========================================================================= #
  def difference
    @future - @current_time
  end
  
  # ========================================================================= #
  # === fraction
  # ========================================================================= #
  def fraction
    difference.to_f/@duration
  end

  # ========================================================================= #
  # === minutes
  # ========================================================================= #
  def minutes
    (difference/60).to_i
  end

  # ========================================================================= #
  # === seconds
  # ========================================================================= #
  def seconds
    (difference % 60).to_i
  end

  # ========================================================================= #
  # === add_leading_zero
  # ========================================================================= #
  def add_leading_zero(i)
    i = "0#{i}" if i.to_s.size == 1
    i.to_s
  end

  # ========================================================================= #
  # === remaining_time?
  # ========================================================================= #
  def remaining_time?
    minutes_str = add_leading_zero(minutes)
    seconds_str = add_leading_zero(seconds)
    "#{minutes_str}:#{seconds_str}"
  end
  
end; end; end