#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TimerWindow::TimerWindow
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk2/timer_window/timer_window.rb'
# Gtk::TimerWindow::TimerWindow.run
# =========================================================================== #
require 'gtk_paradise/require_gtk2'
require 'gtk_paradise/widgets/gtk2/timer_window/panel.rb'

module Gtk

module TimerWindow

class TimerWindow < Gtk::Window

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  require 'singleton'
  include Singleton

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === DEFAULT_ICON
  # ========================================================================= #
  DEFAULT_ICON = 
    "#{PROJECT_BASE_DIRECTORY}images/misc/tomato.png"

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      title     = 'TimerWindow',
      icon_path = DEFAULT_ICON
    )
    super()
    reset
    create_the_main_panel_then_add_it
    self.title = title
    self.allow_grow = false
    self.window_position = Gtk::Window::POS_CENTER_ALWAYS
    self.icon = GdkPixbuf::Pixbuf.new(file: icon_path)
    show_all
    add_close_event
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
  end

  # ========================================================================= #
  # === create_the_main_panel_then_add_it
  # ========================================================================= #
  def create_the_main_panel_then_add_it
    @panel = Panel.new
    add(@panel)
  end

  # ========================================================================= #
  # === pop_up
  # ========================================================================= #
  def pop_up
    self.keep_above = true
    self.keep_above = false
  end

  # ========================================================================= #
  # === panel?
  # ========================================================================= #
  def panel?
    @panel
  end; alias panel panel? # === panel

  # ========================================================================= #
  # === show_warning_dialog message
  #
  # This method will generate a warning-dialog.
  # ========================================================================= #
  def show_warning_dialog message
    dialog = create_warning_dialog(message)
    dialog.run
    dialog.destroy
  end

  private

  # ========================================================================= #
  # === create_warning_dialog
  # ========================================================================= #
  def create_warning_dialog(message)
    dialog = Gtk::MessageDialog.new(
      self,
      Gtk::Dialog::MODAL,
      Gtk::MessageDialog::WARNING,
      Gtk::MessageDialog::BUTTONS_CLOSE,
      message
    )
    dialog.window_position = Gtk::Window::POS_CENTER_ALWAYS
    dialog
  end

  # ========================================================================= #
  # === add_close_event
  # ========================================================================= #
  def add_close_event
    signal_connect(:destroy) {
      puts 'Exiting the TimerWindow next.'
      Gtk.main_quit
    }
  end

  # ========================================================================= #
  # === Gtk::TimerWindow::TimerWindow.run
  # ========================================================================= #
  def self.run
    Gtk::TimerWindow::TimerWindow.instance
    Gtk.main
  end

end; end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::TimerWindow::TimerWindow.run
end