#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ToolbarExample
#
# This class shall mostly demonstrate, and thus display, how the
# Gtk::Toolbar can be used, in ruby-gtk. It shall cover several
# use cases, if possible.
# =========================================================================== #
require 'gtk_paradise/require_gtk2'

module Gtk

class ToolbarExample < ::Gtk::HBox # === Gtk::ToolbarExample

  require 'gtk_paradise/gtk_classes/toolbar.rb'

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # =========================================================================== #
  # === THE_XPM_IMAGE
  #
  # gi $MY_USERS/x/DATA/IMG/STD/EMAIL_FAVICON.xpm
  # ========================================================================= #
  THE_XPM_IMAGE = '/home/x/DATA/images/STD/EMAIL_FAVICON.xpm'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize
    super()
    reset
    # ======================================================================= #
    # Create a new Gtk::Toolbar here.
    # ======================================================================= #
    toolbar = gtk_toolbar
    toolbar.append('Horizontal', 'Horizontal toolbar layout', 'Toolbar/Horizontal',
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.orientation = Gtk::ORIENTATION_HORIZONTAL
    }

    toolbar.append('Vertical', 'Vertical toolbar layout', 'Toolbar/Vertical',
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.orientation = Gtk::ORIENTATION_VERTICAL
    }

    toolbar.append_space
    toolbar.append('Icons', 'Only show toolbar icons', 'Toolbar/IconsOnly',
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.toolbar_style = Gtk::Toolbar::ICONS
    }

    toolbar.append('Text', 'Only show toolbar text', 'Toolbar/TextOnly',
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.toolbar_style = Gtk::Toolbar::TEXT
    }

    toolbar.append('Both', 'Show toolbar icons and text', 'Toolbar/Both',
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.toolbar_style = Gtk::Toolbar::BOTH
    }
    toolbar.append_space
    toolbar.append('Enable', 'Enable tooltips',nil,
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.tooltips = true
    }

    toolbar.append_space
    toolbar.append('Disable', 'Disable tooltips',nil,
      gtk_image(THE_XPM_IMAGE)
    ) {
      toolbar.tooltips = false
    }

    toolbar.append_space
    toolbar.append(
      gtk_button('Hello world')
    )
    maximal(toolbar, 2)
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run.rb'
  r = Gtk.run(
    520,80,
    :tabble_picture,
    'Toolbar',
    2
  )
  r << Gtk::ToolbarExample.new
  r.set_background :beige
  r.enable_quick_exit
  r.show_all.top_left_then_run
end # toolbarexample