#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::BurnThisIsoFile
# =========================================================================== #
# require 'gtk_paradise/widgets/burn_this_iso_file/burn_this_iso_file.rb'
# Gtk::BurnThisIsoFile.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class BurnThisIsoFile < ::Gtk::BaseModuleBox # === Gtk::BurnThisIsoFile 

  begin
    require 'roebe/classes/burn_iso/burn_iso.rb'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Burn .iso files'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '25% or minimum 200px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '12% or minimum 88px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_16

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === create_the_entries                           (entries tag, entry tag)
  # ========================================================================= #
  def create_the_entries
    # ======================================================================= #
    # === @entry_burn_this_iso_file
    # ======================================================================= #
    @entry_burn_this_iso_file = gtk_entry
    @entry_burn_this_iso_file.bblack1
    @entry_burn_this_iso_file.pad5px
    @entry_burn_this_iso_file.yellowish_background
    @entry_burn_this_iso_file.width_height(550, 25)
    @entry_burn_this_iso_file.center
  end

  # ========================================================================= #
  # === main_entry?
  # ========================================================================= #
  def main_entry?
    @entry_burn_this_iso_file
  end

  # ========================================================================= #
  # === set_main_entry_to
  # ========================================================================= #
  def set_main_entry_to(i)
    @entry_burn_this_iso_file.set_text(i.to_s)
  end

  # ========================================================================= #
  # === create_the_first_row
  # ========================================================================= #
  def create_the_first_row
    @first_row = gtk_hbox
    @first_row.minimal(text('Burn this .iso file: '), 5)
    create_the_entries
    @first_row.minimal(@entry_burn_this_iso_file, 5)
    button_choose_a_file = default_choose_filer
    button_choose_a_file.bblack1
    button_choose_a_file.pad5px
    button_choose_a_file.on_clicked {
      do_create_a_new_file_chooser_dialog
    }
    @first_row.minimal(button_choose_a_file, 5)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    create_the_first_row
    minimal(@first_row)
    second_row = gtk_hbox
    this_image = image_media_optical
    event_box = gtk_event_box(this_image)
    event_box.hint = 'Click on this button in to order '\
                     'to <b>burn the .iso file</b> at hand. '\
                     'This functionality depends on the <b>roebe</b> gem.'
    event_box.on_clicked {
      do_burn_the_iso_file
    }
    second_row.minimal(event_box)
    second_row.halign_center
    minimal(second_row, 15)
  end

  # ========================================================================= #
  # === do_create_a_new_file_chooser_dialog
  # ========================================================================= #
  def do_create_a_new_file_chooser_dialog
    create_a_new_file_chooser_dialog(self) {{
      filter:             '.iso',
      additional_folders: '/Depot/ISOs/',
      start_dir:          '/Depot/ISOs/'
    }}
    _ = ::Gtk.main_file?
    if _ and File.exist?(_)
      set_main_entry_to(_)
    end
  end

  # ========================================================================= #
  # === do_burn_the_iso_file
  # ========================================================================= #
  def do_burn_the_iso_file
    _ = absolute_file_path(main_entry?.text?)
    if _ and !_.empty?
      if Object.const_defined?(:Roebe) and Roebe.const_defined?(:BurnISO)
        popup_widget = popup_over_this_widget(
            main_entry?,
          'Finished burning <b>'+_+'</b>.'
        )
        Thread.new {
          e 'Now delegating towards Roebe::BurnISO, with the '\
            'file path being: '+sfile(_)
          burn_iso = Roebe::BurnISO.new(_, :dont_run_yet)
          burn_iso.be_verbose
          burn_iso.run
          popup_widget.popup
        }
      end
    else
      e 'You should first assign a new .iso file.'
    end
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::BurnThisIsoFile.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::BurnThisIsoFile.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::BurnThisIsoFile.run
end