#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::CheckboxImage
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/checkbox_image/checkbox_image.rb'
# Gtk::CheckboxImage.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class CheckboxImage < ::Gtk::BaseModuleBox # === Gtk::CheckboxImage 

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Pick a proper title here please.'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '1% or minimum 10px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '1% or minimum 10px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_15

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    @image = gtk_image
    # ======================================================================= #
    # On startup the checkbox is set to off.
    # ======================================================================= #
    the_checkbox_is_off
    event_box = gtk_event_box(@image)
    maximal(event_box)
  end

  # ========================================================================= #
  # === the_checkbox_is_on
  # ========================================================================= #
  def the_checkbox_is_on
    _ = @image
    _.from_pixbuf = return_pixbuf_based_on_the_default_icon_theme(
      'checkbox-checked-symbolic.symbolic'
    )
    return true
  end

  # ========================================================================= #
  # === the_checkbox_is_off
  # ========================================================================= #
  def the_checkbox_is_off
    _ = @image
    _.from_pixbuf = return_pixbuf_based_on_the_default_icon_theme(
      'checkbox-symbolic.symbolic'
    )
    return false
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::CheckboxImage.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::CheckboxImage.new(i)
    # _.the_checkbox_is_on
    _.the_checkbox_is_off
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::CheckboxImage.run
end