#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/editor/connect_skeleton.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class Editor < ::Gtk::BaseModuleBox # === Gtk::Editor

  # ========================================================================= #
  # === return_the_second_row
  # ========================================================================= #
  def return_the_second_row
    very_left_hbox = gtk_hbox
    very_left_hbox.minimal(@insert_character, 1)

    middle_vbox = gtk_vbox
    middle_vbox.minimal(@retrieve_button)
    middle_vbox.minimal(@entry_insert_this_text, 1)
    middle_vbox.minimal(@button_insert)
    middle_vbox.minimal(@button_delete_selection)

    first_dragger = drag_from_left_to_right(very_left_hbox, middle_vbox)
    first_dragger.position = 435
    # ======================================================================= #
    # The upper hbox is defined next:
    # ======================================================================= #
    notebook_on_top = return_default_notebook
    notebook_on_top.position_to_the_right

    tiny_hbox_situated_in_the_notebook = gtk_hbox
    tiny_hbox_situated_in_the_notebook.minimal(return_the_colour_palette, 1) # Add the colour palette here.
    tiny_hbox_situated_in_the_notebook.minimal(return_font_size_widget,   1)
    notebook_on_top.add_tab(tiny_hbox_situated_in_the_notebook, '1') # Add the first tab-widget.
    notebook_on_top.add_tab(return_widget_containing_special_buttons, '2') # This one has various buttons.
    # ======================================================================= #
    # Try to make use of VTE next:
    # ======================================================================= #
    consider_adding_a_vte_terminal_to_this_notebook(notebook_on_top)

    second_dragger = drag_from_left_to_right(first_dragger, notebook_on_top)
    second_dragger.position = 730

    button_box = gtk_vbox(
      @button_clear_the_textbuffer,
      @button_colourize_the_text
    )
    third_dragger = drag_from_left_to_right(second_dragger, button_box)
    third_dragger.position = 1650
    return third_dragger
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    create_then_add_the_header_bar
    second_row = return_the_second_row

    if @use_widget_with_different_colour_buttons
      hbox = draggable_via_left_to_right_movement(
        @notebook,
        return_widget_with_different_colour_buttons
      )
      hbox.position = width? * 0.94
      _ = draggable_via_up_and_down_movements(second_row, hbox)
    else
      _ = draggable_via_up_and_down_movements(second_row, @notebook)
    end

    lower_hbox = gtk_hbox
    lower_hbox.minimal(@entry_save_into_this_local_file,       3)
    lower_hbox.minimal(@button_save_the_content_of_the_buffer, 3)
    lower_hbox.minimal(@label_indicate_the_cursor_position,    8)
    lower_hbox.minimal(@label_n_lines_in_the_file,             3)
    lowest_vbox = gtk_vbox
    lowest_vbox.minimal(lower_hbox)
    lowest_vbox.maximal(@status_bar)

    draggable1 = draggable_via_up_and_down_movement(
      _,
      lowest_vbox
    )
    draggable1.position = (height? * 0.94)
    maximal(draggable1)
  end

end; end