#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::FontSizeWidget::ActionButton
#
# The FontSizeWidget contains these smaller action-buttons.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/font_size_widget/action_button.rb'
# Gtk::FontSizeWidget::ActionButton
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class FontSizeWidget

class ActionButton < ::Gtk::BaseModuleButton # === Gtk::FontSizeWidget::ActionButton

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_arguments = ARGV
    )
    super()
    reset
    if optional_arguments
      if optional_arguments.is_a? Array
        set_text_displayed_on_the_button(optional_arguments)
      end
    end
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @text_displayed_on_the_button
    # ======================================================================= #
    @text_displayed_on_the_button = nil
    set_size_request(20, 10)
  end

  # ========================================================================= #
  # === set_text_displayed_on_the_button
  # ========================================================================= #
  def set_text_displayed_on_the_button(i = nil)
    if i.is_a? Array
      i = i.first
    end
    @text_displayed_on_the_button = i
  end; alias text_displayed_on_the_button= set_text_displayed_on_the_button # === text_displayed_on_the_button=
       alias set_new_text                  set_text_displayed_on_the_button # === set_new_text

end; end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::FontSizeWidget::ActionButton.new('Hey there')
end