#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::InsertCharacter
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/insert_character/insert_character.rb'
# Gtk::InsertCharacter.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class InsertCharacter < ::Gtk::Box # === Gtk::InsertCharacter 

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Insert Character'

  # ========================================================================= #
  # === ARRAY_ADD_THESE_CHARACTERS
  #
  # Add the following characters by default. The '#' is for a comment.
  # ========================================================================= #
  ARRAY_ADD_THESE_CHARACTERS = %w(
    ₁
    ₂
    ₃
    ₄
    ₅
    ₆
    ₇
    ₈
    ₉
    ₀
    ¹
    ²
    ³
    ⁴
    ⁵
    ⁶
    ⁷
    ⁸
    ⁹
    ⁰
    ⁺
    ⁻
    #
    π
    Σ
  )

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '15% or minimum 180px'
 
  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 50

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    # ======================================================================= #
    # === @attach_to_this_text_buffer
    #
    # This variable can be used to attach this onto a text buffer.
    # ======================================================================= #
    @attach_to_this_text_buffer = nil
    # ======================================================================= #
    # === @delete_the_selected_text_in_the_buffer
    # ======================================================================= #
    @delete_the_selected_text_in_the_buffer = false
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_the_grid
  end

  # ========================================================================= #
  # === create_the_grid                                            (grid tag)
  # ========================================================================= #
  def create_the_grid
    # ======================================================================= #
    # === @grid
    # ======================================================================= #
    @grid = default_grid
    @grid.hcenter
    # @grid.set_halign(:center)
    # @grid.set_valign(:center)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add_the_default_characters
    minimal(@grid, 0)
  end

  # ========================================================================= #
  # === attach_to_this_text_buffer
  # ========================================================================= #
  def attach_to_this_text_buffer(i)
    @attach_to_this_text_buffer = i
  end; alias attach_to_this_buffer attach_to_this_text_buffer # === attach_to_this_buffer

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === append_this_button
  # ========================================================================= #
  def append_this_button(
      text_to_display = ' # '
    )
    button = gtk_button(text_to_display.to_s)
    button.bblack1
    button.pad1px
    button.set_size_request(34, 34)
    button.on_clicked {
      do_handle_this_symbol(button.text?)
    }
    @grid.left(button)
    Gtk::Grid.increment_left_position
  end

  # ========================================================================= #
  # === new_row
  # ========================================================================= #
  def new_row
    @grid.new_row
  end

  # ========================================================================= #
  # === add_the_default_characters
  # ========================================================================= #
  def add_the_default_characters(
      i = ARRAY_ADD_THESE_CHARACTERS
    )
    index = 0
    i.each {|this_symbol| index += 1
      append_this_button(this_symbol)
      if index > 11
        @grid.new_row
        @grid.reset_left_position
        index = 0
      end
    }
  end

  # ========================================================================= #
  # === do_handle_this_symbol
  # ========================================================================= #
  def do_handle_this_symbol(i)
    if @attach_to_this_text_buffer
      # ===================================================================== #
      # Insert at the cursor in this case.
      # ===================================================================== #
      delete_selection(@attach_to_this_text_buffer)
      @attach_to_this_text_buffer.append_after_the_cursor(i)
    else
      e i
    end
  end

  # ========================================================================= #
  # === delete_selection
  # ========================================================================= #
  def delete_selection(
      buffer = @attach_to_this_text_buffer
    )
    if buffer and @delete_the_selected_text_in_the_buffer
      buffer.delete_selection(false, false)
    end
  end; alias delete_the_selected_text_in_the_buffer delete_selection # === delete_the_selected_text_in_the_buffer

  # ========================================================================= #
  # === do_delete_the_selected_text_in_the_buffer
  # ========================================================================= #
  def do_delete_the_selected_text_in_the_buffer
    @delete_the_selected_text_in_the_buffer = true
  end

  # ========================================================================= #
  # === Gtk::InsertCharacter.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::InsertCharacter.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::InsertCharacter.run
end