#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NotebookWithStorageFunctionality
#
# This notebook can be used if you need a save-into-file functionality.
#
# Eventually this widget should be made very flexible.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/notebook_with_storage_functionality/notebook_with_storage_functionality.rb'
# Gtk::NotebookWithStorageFunctionality.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class NotebookWithStorageFunctionality < ::Gtk::BaseModuleBox # === Gtk::NotebookWithStorageFunctionality 

  require 'yaml'

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Notebook with storage functionality'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '95% or minimum 1480px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '55% or minimum 600px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :hack_22

  # ========================================================================= #
  # === SMALLER_FONT
  # ========================================================================= #
  SMALLER_FONT = :hack_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    horizontal_center
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    handle_CSS_rules
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === handle_CSS_rules                                            (CSS tag)
  # ========================================================================= #
  def handle_CSS_rules
    use_gtk_paradise_project_css_file
  end

  # ========================================================================= #
  # === smaller_font?
  # ========================================================================= #
  def smaller_font?
    SMALLER_FONT
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    @text_view = create_text_view
    maximal(@text_view)
    button_store_the_content = create_button('_Store the content')
    button_store_the_content.hint = 'Click this button to '\
                                    'store the content into a file.'
    button_store_the_content.on_clicked {
      do_store_the_content
    }
    button_store_the_content.clear_background
    button_store_the_content.on_hover(:lightblue)
    button_store_the_content.bblack2
    button_store_the_content.pad4px
    button_store_the_content.css_class('margin2px')
    box1 = create_hbox
    box1.minimal(button_store_the_content, 2)
    box1.hcenter
    minimal(box1)
  end

  # ========================================================================= #
  # === do_store_the_content
  # ========================================================================= #
  def do_store_the_content
    _ = @text_view.text?
    into = '/home/x/Temp/notebook_content.md'
    write_what_into(_, into)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::NotebookWithStorageFunctionality.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::NotebookWithStorageFunctionality.new(i)
    r = ::Gtk.run
    r << _
    # ======================================================================= #
    # Add two convenience keybindings next:
    # ======================================================================= #
    r.alt_key(1, 'focus_entry(1)') # alt+1
    r.alt_key(2, 'focus_entry(2)') # alt+2
    r.alt_key(3, 'focus_entry(3)') # alt+3
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::NotebookWithStorageFunctionality.run
end