#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::NumbersOnly
#
# Gtk::NumbersOnly is a specialized Gtk::Entry, that can be restricted
# so that only valid numbers (such as 1, 2, 3) can be entered. Additionally
# the '.' dot character is also allowed, even though it is not a number
# in itself - but it is often used for floats, such as "2.3" or "-4.1".
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/numbers_only/numbers_only.rb'
# Gtk::NumbersOnly.new
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class NumbersOnly < ::Gtk::Entry # === Gtk::NumbersOnly

  # ========================================================================= #
  # === initialize
  #
  # Initialize a new Gtk::NumbersOnly object.
  # ========================================================================= #
  def initialize
    super()
    reset
    run
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
  end

  # ========================================================================= #
  # === register_the_signals
  # ========================================================================= #
  def register_the_signals
    signal_connect(:insert_text) {|wid, string|
      # Allow ' ' characters.
      unless is_a_valid_number?(string) or string == ' '
        signal_emit_stop(:insert_text)
      end
    }
  end

  # ========================================================================= #
  # === is_a_valid_number?
  #
  # Checks if the input is a valid number.
  # ========================================================================= #
  def is_a_valid_number?(i)
    i =~ /[0-9]/
  end; private :is_a_valid_number?

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    register_the_signals
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  numbers_only = Gtk::NumbersOnly.new
  r = Gtk.run(
    add: numbers_only,
    width: 220,
    height: 80
  )
  r.set_border_width(12)
  r.top_left_and_show_all
  r.run
end