#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::SysMessage
#
# This small widget is just a wrapper over xosd.
# =========================================================================== #
# require 'gtk_paradise/gui/gtk3/sys_message/sys_message.rb'
# Gtk::SysMessage.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class SysMessage < ::Gtk::BaseModuleBox # === Gtk::SysMessage 

  begin
    require 'roebe/classes/on_screen_display.rb'
  rescue LoadError; end

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Sys-Message'

  # ========================================================================= #
  # === ALPHABET
  # ========================================================================= #
  ALPHABET = ('a'..'z').to_a

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '55% or minimum 1400px'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '5% or minimum 80px'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :hack_20

  # ========================================================================= #
  # === initialize
  #
  # The first argument to this method contains the String that the user
  # may want to send.
  # ========================================================================= #
  def initialize(
      text        = ARGV,
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
    set_text(text) if text
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === Set the title, width, height and the font in use.
    # ======================================================================= #
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === Gtk::SysMessage.width?
  # ========================================================================= #
  def self.width?
    WIDTH
  end

  # ========================================================================= #
  # === Gtk::SysMessage.height?
  # ========================================================================= #
  def self.height?
    HEIGHT
  end

  # ========================================================================= #
  # === create_the_entries
  #
  # Here you can add text thingies.
  # ========================================================================= #
  def create_the_entries
    # ======================================================================= #
    # === @entry_message
    # ======================================================================= #
    @entry_message = entry
    @entry_message.set_max_length(150)
    @entry_message.set_focus(true)
    @entry_message.set_activates_default(true)
    @entry_message.clear_background
    @entry_message.bblack1
    @entry_message.yellowish_background
    @entry_message.pad8px
    @entry_message.on_enter {
      do_send_the_message
    }
  end

  # ========================================================================= #
  # === set_text
  # ========================================================================= #
  def set_text(i = nil)
    if i
      i = i.join(' ').strip if i.is_a? Array
      @entry_message.set_text(i.to_s)
    end
  end

  # ========================================================================= #
  # === do_send_the_message
  # ========================================================================= #
  def do_send_the_message
    # Second arg is true, so we output the sys message.
    Roebe::OnScreenDisplay.new(@entry_message.text, false).random_display
  end

  # ========================================================================= #
  # === create_the_buttons                          (buttons tag, button tag)
  # ========================================================================= #
  def create_the_buttons
    # ======================================================================= #
    # === @button_send_message
    # ======================================================================= #
    @button_send_message = button('_SendMessage')
    @button_send_message.hint = 'Click this button in order '\
      'to send the message via xosd.'
    @button_send_message.on_clicked {
      do_send_the_message
    }
    # ======================================================================= #
    # === @button_random_message
    # ======================================================================= #
    @button_random_message = button('_RandomMessage')
    @button_random_message.on_clicked {
      this_text = ''.dup
      8.times { this_text << ALPHABET.sample }
      e this_text
      Roebe::OnScreenDisplay.new(this_text, true).random_display
    }
    array_buttons = [
      @button_send_message, @button_random_message
    ]
    array_buttons.each { |button|
      if button.label == '_RandomMessage'
        button.modify_background(:normal, :lawngreen)
      else
        button.modify_background(:normal, :greenyellow)
      end
      button.modify_background(:active, :darkcyan)
      button.modify_background(:prelight, :ivory)
      button.set_name('button1')
      button.bblack2
      button.set_size_request(120, 25)
      button.do_not_resize
    }
  end

  # ========================================================================= #
  # === create_skeleton                            (create tag, skeleton tag)
  # ========================================================================= #
  def create_skeleton
    create_the_entries
    create_the_buttons
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    minimal(@button_send_message,2)
    maximal(@entry_message,2)
    minimal(@button_random_message,2)
    exit_on_delete_event
    show_all
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
    Thread.new {
      sleep 0.0001
      @entry_message.do_focus
    }
  end

  # ========================================================================= #
  # === Gtk::SysMessage.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = Gtk::SysMessage.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.enable_quick_exit
    r.top_left_then_run
  end

end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::SysMessage.run
end