#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Tabble::AdminPanel
#
# This class is used for the lower hbox of Gtk::Tabble, which will
# contain a check-button.
#
# It also asks whether the user wants to additionally compile the
# program at hand.
# =========================================================================== #
# require 'gtk_paradise/widgets/gtk3/tabble/admin_panel.rb'
# Gtk::Tabble::AdminPanel.run
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class Tabble < ::Gtk::Box

class AdminPanel < ::Gtk::Box # === Gtk::Tabble::AdminPanel 

  require 'gtk_paradise/widgets/gtk3/tabble/constants.rb'

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = ::Gtk::Tabble::USE_THIS_FONT

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Admin Panel for Tabble'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1280

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 600

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:horizontal)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    set_use_this_font(USE_THIS_FONT)
    use_gtk_paradise_project_css_file # or use use_project_css_file 
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === button_check_compile_programs?
  # ========================================================================= #
  def button_check_compile_programs?
    @button_check_compile_programs
  end

  # ========================================================================= #
  # === compile_program?
  # ========================================================================= #
  def compile_program?
    @compile_program
  end; alias compile_program compile_program? # === compile_program

  # ========================================================================= #
  # === add_check_button
  #
  # This method will add a check-button.
  # ========================================================================= #
  def add_check_button
    @button_check_compile_programs = gtk_bold_check_button(
      'Additionally compile the program?', true
    )
    @button_check_compile_programs.is_inactive # You can change whether it is clicked on startup or not.
    @button_check_compile_programs.set_name(
      'BG_white_and_darkblue'
    )
    @button_check_compile_programs.hint = 
      "If this button is <b>checked</b> then the selected program "\
      "will also\nbe <b>compiled</b>, upon the click-event."
    minimal(@button_check_compile_programs, 1)
  end

  # ========================================================================= #
  # === connect_skeleton
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add_check_button
    act_on_button_press_event
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
    set_size_request(120, 60)
  end

  # ========================================================================= #
  # === act_on_button_press_event
  # ========================================================================= #
  def act_on_button_press_event
    @button_check_compile_programs.on_toggled { |widget|
      if widget.active?
        @compile_program = true
      elsif not widget.active?
        @compile_program = false
      end
    } 
  end

  # ========================================================================= #
  # === Gtk::Tabble::AdminPanel.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::Tabble::AdminPanel.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size_then_automatic_title
    r.top_left_then_run
  end

end; end; end

if __FILE__ == $PROGRAM_NAME
  Gtk::Tabble::AdminPanel.run
end