#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ColouredBarModule
#
# To change the display, use the .rescale_to() method.
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/coloured_bar/coloured_bar_module.rb'
# include ::Gtk::ColouredBarModule
# =========================================================================== #
module Gtk

module ColouredBarModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'ColouredBar'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 800

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 50

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_18

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    # ======================================================================= #
    # === @occupy_n_percent
    # ======================================================================= #
    @occupy_n_percent = 63
    # ======================================================================= #
    # === @text_on_the_right_widget
    # ======================================================================= #
    @text_on_the_right_widget = nil
    # ======================================================================= #
    # === @colour1
    # ======================================================================= #
    @colour1 = :black
    # ======================================================================= #
    # === @colour2
    #
    # This is actually the background-image.
    # ======================================================================= #
    @colour2 = :yellow
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    @height = 40
    set_use_this_font(USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    0
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    0
  end

  # ========================================================================= #
  # === set_height
  # ========================================================================= #
  def set_height(i)
    @height = i.to_i
  end

  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
    @box1 = gtk_vbox
    @box1.css_class('BG_black')
    @box1.css_class('pad0px')
    @box1.css_class('mar0px')
    @box1.disallow_resizing

    @box2 = gtk_vbox
    @box2.css_class('BG_yellow')
    @box2.css_class('pad0px')
    @box2.css_class('mar0px')
    @box2.disallow_resizing

    @label = gtk_bold_label()
    @label.center
    @label.css_class('black')
    @box2.add(@label)

    box_containing_two_boxes = gtk_hbox
    box_containing_two_boxes.minimal(@box1)
    box_containing_two_boxes.minimal(@box2)
    box_containing_two_boxes.use_these_css_classes('no_box_shadow pad0px mar0px')

    @frame = gtk_frame(box_containing_two_boxes)
    @frame.use_these_css_classes('no_box_shadow bblack2 BG_black pad0px mar0px')
    rescale(:default_value)
  end

  # ========================================================================= #
  # === set_occupy_n_percent
  # ========================================================================= #
  def set_occupy_n_percent(i)
    @occupy_n_percent = i
  end; alias set_percentage_value set_occupy_n_percent # === set_percentage_value

  # ========================================================================= #
  # === rescale_to
  #
  # This method can be used to rescale the two widgets.
  # ========================================================================= #
  def rescale_to(
      n_percent = @occupy_n_percent,
      colour1   = @colour1,
      colour2   = @colour2
    )
    case n_percent
    # ======================================================================= #
    # === :default_value
    # ======================================================================= #
    when :default_value,
         :default
      n_percent = 63
      # set_colour_left(:darkblue)
    end
    @occupy_n_percent = n_percent
    if n_percent.is_a? String
      n_percent = n_percent.delete('%').to_i
    end
    occupy_left = (@width * @occupy_n_percent.to_f) / 100
    @box1.set_size_request(occupy_left, @height)
    occupy_right = @width - occupy_left
    @box2.set_size_request(occupy_right, @height)
    @text_on_the_right_widget = "#{n_percent}%"
    @label.set_text(@text_on_the_right_widget.to_s)
  end; alias rescale    rescale_to # === rescale
       alias do_rescale rescale_to # === rescale

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    maximal(@frame)
  end

  # ========================================================================= #
  # === set_colour2
  # ========================================================================= #
  def set_colour2(i = @colour2)
    @colour2 = i
    _ = "BG_#{i}"
    @box2.set_name(_)
  end

  # ========================================================================= #
  # === set_use_this_colour
  # ========================================================================= #
  def set_use_this_colour(i = :default)
    @colour1 = i
    case i
    when :default
      i = :black
    end
    _ = "BG_#{i}"
    @box1.set_name(_)
  end; alias set_colour_left set_use_this_colour # === set_colour_left
       alias set_colour1     set_use_this_colour # === set_colour1

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::ColouredBarModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::ColouredBar.new(i)
    r = ::Gtk.run
    r << _
    r.set_size_request(_.width?, _.height?)
    r.set_default_size(_.width?, _.height?)
    r.top_left_then_run
  end

end; end