#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/customizable_dialog/customizable_dialog.rb'
# Gtk::CustomizableDialog.new
# =========================================================================== #
require 'gtk_paradise/require_gtk3'

module Gtk

class CustomizableDialog < ::Gtk::Dialog

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 620

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(parent = nil)
    super()
    reset
    set_title 'Gtk::Dialog Sample'
    set_default_size(WIDTH, 250)
    move(0, 0)
    set_font(:hack_20)
    if parent
      set_parent(parent)
      set_transient_for(parent)
    end 
    child.add(
      gtk_label('Customizable Dialog')
    )
    child.add(
      gtk_label('Use this font:')
    )
    @entry_font_to_use = gtk_entry()
    child.add(
      @entry_font_to_use
    )

    add_button('OK', :ok)
    add_button(::Gtk::Stock::CANCEL, :cancel)
    add_button(::Gtk::Stock::CLOSE, :close)
    set_default_response(
      ::Gtk::ResponseType::CANCEL
    )
    result = run()
    case result
    when :ok, -5
      # e 'OK'
    when :cancel, -6
      # e 'Cancel'
    when :close, -7
      # e 'Close'
      destroy
    end
    show_all
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, infer_the_namespace]
  end

  # ========================================================================= #
  # === user_choice?
  # ========================================================================= #
  def user_choice?
    @entry_font_to_use.text?
  end

end; end

if __FILE__ == $PROGRAM_NAME
  require 'gtk_paradise/run'
  Gtk::CustomizableDialog.new
  Gtk.main
end # rb gtk_dialog_sample.rb