#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ListStoreTable3Module
#
# Note that this example also 
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/list_store_table3/list_store_table3_module.rb'
# include ::Gtk::ListStoreTable3Module
# =========================================================================== #
module Gtk

module ListStoreTable3Module

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Table3'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 150

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 150

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    set_height(HEIGHT)
    set_dataset(%w(
      A  B  C
      D  E  F
      G  H  I
      J  K  L
    ))
    set_font(:hack_20)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end
  
  # ========================================================================= #
  # === create_skeleton
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === set_dataset
  # ========================================================================= #
  def set_dataset(i)
    @dataset = i
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    exit_on_delete_event
    show_all
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    # ======================================================================= #
    # This is where we pass in an "array". This is hardcoded, but you
    # can simply use an Array for your own gtk-application.
    # ======================================================================= #
    _ = add_table3(*@dataset)
  end

  # ========================================================================= #
  # === ::Gtk::ListStoreTable3[]
  # ========================================================================= #
  def self.[](i = '')
    new(i)
  end

  # ========================================================================= #
  # === GtkParadise::GUI::Gtk::ListStoreTable3Module.run
  # ========================================================================= #
  def self.run
    require 'gtk_paradise/run'
    _ = ::Gtk::ListStoreTable3.new
    r = ::Gtk.run
    r << _
    r.automatic
    r.top_left_then_run
  end

end; end