#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::OneColumnWithTextAndImageModule
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/one_column_with_text_and_image/one_column_with_text_and_image_module.rb'
# include ::Gtk::OneColumnWithTextAndImageModule
# =========================================================================== #
module Gtk

module OneColumnWithTextAndImageModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  require 'base64'

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Multiple cells in a column'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '45%'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '28%'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === DATASET
  # ========================================================================= #
  DATASET = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAnElEQVR42nWO
PQvCMBCGz4qdXF38GvRnKG7+/yVLFVfToFHbqGiTS3xPKNTBgwfecA/vhdqx
KttYRQFcwbqzoAt4gcjeJkEyeMtOBMfeBG6O6QdfSlslQokH/xEKuhWjlVU9
z153BN2e2FK1Gy8gPGIMCVL8tvlTI/VgihP5EOEc2dUignvkp3zcgBwCZWAA
TL2fz9xhOUHWoE+YD9DvsTPOuAjZAAAAAElFTkSuQmCC"

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      optional_file = nil,
      run_already   = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    # ======================================================================= #
    # === @renderer_non_editable
    # ======================================================================= #
    @renderer_non_editable = gtk_cell_renderer_text
    @renderer_non_editable.editable = false
    set_use_this_font(USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    1
  end

  # ========================================================================= #
  # === favicon?
  # ========================================================================= #
  def favicon?
    '/home/x/data/images/PC/FTP/LFTP.png'
  end

  # ========================================================================= #
  # === create_list_store
  # ========================================================================= #
  def create_list_store(n_times = 5)
    loader = pixbuf_loader
    # ======================================================================= #
    # Load the dataset that has been bundled into this .rb file via
    # the constant defined in this class.
    # ======================================================================= #
    data = Base64.decode64(DATASET)
    loader.last_write(data)
    # ======================================================================= #
    # Create model with data for our single column.
    # We use a String, and a pixbuf object.
    # ======================================================================= #
    @list_store_single = gtk_liststore(
      String, GdkPixbuf::Pixbuf
    )
    n_times.times { |counter|
      counter += 1
      iter = @list_store_single.append
      iter[0] = "Text #{counter}"
      iter[1] = loader.pixbuf # Add the image here.
    }
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    create_list_store
    create_column
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    minimal(@tree_view, 2)
  end

  # ========================================================================= #
  # === create_column
  # ========================================================================= #
  def create_column
    @tree_view = gtk_tree_view(@list_store_single)
    @tree_view.pad4px
    @tree_view.set_size_request(680, 250)
    # @tree_view.css_class('bblack2')
    # ======================================================================= #
    # Using shorter constructor for clarity.
    # ======================================================================= #
    @column = gtk_tree_view_column('One column')
    # ======================================================================= #
    # Gtk::TreeViewColumn#pack_start allows us to specify that extra
    # space in the cell. Shouldn't be allocated to the pixbuf.
    # ======================================================================= #
    pixbuf_renderer = gtk_cell_renderer_pixbuf
    @column.pack_start(pixbuf_renderer, false)
    # ======================================================================= #
    # Set attributes so the renderer knows where to find data. This
    # represents the image in use.
    # ======================================================================= #
    @column.set_attributes(pixbuf_renderer, { pixbuf: 1 })
    # ======================================================================= #
    # Add a second renderer to column & set attributes so it knows
    # where to find data.
    # ======================================================================= #
    cell_renderer_text = gtk_cell_renderer_text
    @column.pack_start(cell_renderer_text, true)
    @column.set_attributes(cell_renderer_text, {text: 0})
    # ======================================================================= #
    # Add the column to Gtk::TreeView.
    # ======================================================================= #
    @tree_view.append_column(@column)
    # ======================================================================= #
    # If you must add new entries, consider the following code:
    #   @tree_view.insert_column(-1, '#id',   @renderer_non_editable, text: 1)
    # ======================================================================= #
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::OneColumnWithTextAndImageModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::OneColumnWithTextAndImage.new(i)
    r = ::Gtk.run
    r << _
    r.infer_the_title_from_the_child_widget
    r.window_position_none
    r.automatic
    r.modify_background(:normal, :lightcyan)
    r.top_left_then_run
  end

end; end