#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::TextEntryWidgetModule
#
# The idea for this widget is to show a text on the left-side, and then
# a gtk-entry on the right side. The value of that gtk-entry is also
# stored on the toplevel Gtk "namespace".
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/text_entry_widget/text_entry_widget_module.rb'
# include ::Gtk::TextEntryWidgetModule
# =========================================================================== #
module Gtk

# =========================================================================== #
# === @last_user_input
# =========================================================================== #
@last_user_input = nil

# =========================================================================== #
# === Gtk.last_user_input=
# =========================================================================== #
def self.last_user_input=(i)
  @last_user_input = i
end

# =========================================================================== #
# === Gtk.last_user_input?
# =========================================================================== #
def self.last_user_input?
  @last_user_input
end

module TextEntryWidgetModule

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'Text Entry Widget'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = 1200

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = 500

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_20

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      commandline_arguments = ARGV,
      run_already           = true
    )
    super(:vertical)
    reset
    set_commandline_arguments(
      commandline_arguments
    )
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    # ======================================================================= #
    # === @title
    # ======================================================================= #
    @title  = TITLE
    # ======================================================================= #
    # === @width
    # ======================================================================= #
    set_width(WIDTH)
    # ======================================================================= #
    # === @height
    # ======================================================================= #
    set_height(HEIGHT)
    set_use_this_font(USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    2
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
  end

  # ========================================================================= #
  # === assign_to_the_main_selection
  # ========================================================================= #
  def assign_to_the_main_selection(
      i = @entry_text_input.text?
    )
    ::Gtk.last_user_input = i
  end

  # ========================================================================= #
  # === user_input?
  # ========================================================================= #
  def user_input?
    ::Gtk.last_user_input?
  end; alias selection? user_input? # === selection?

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    @left_side = text('Make your selection:')
    @entry_text_input = gtk_entry
    @entry_text_input.set_size_request(250, 40)
    @entry_text_input.css_class('pad4px')
    @entry_text_input.on_enter {
      assign_to_the_main_selection(@entry_text_input.text?)
    }
    hbox = gtk_hbox
    hbox.minimal(@left_side,        5)
    hbox.minimal(@entry_text_input, 5)
    minimal(hbox)
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    create_skeleton_then_connect_skeleton
  end

  # ========================================================================= #
  # === Gtk::TextEntryWidgetModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::TextEntryWidget.new(i)
    r = ::Gtk.run
    r << _
    r.automatic_size
    r.automatic_title
    r.top_left_then_run
  end

end; end