#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::XpmLoaderModule
# =========================================================================== #
# require 'gtk_paradise/widgets/shared_code/xpm_loader/xpm_loader_module.rb'
# include ::Gtk::XpmLoaderModule
# =========================================================================== #
module Gtk

module XpmLoaderModule # === Gtk::XpmLoaderModule

  include ::Gtk::BaseModule

  # ========================================================================= #
  # === TITLE
  # ========================================================================= #
  TITLE = 'XPM Loader'

  # ========================================================================= #
  # === WIDTH
  # ========================================================================= #
  WIDTH = '60%'

  # ========================================================================= #
  # === HEIGHT
  # ========================================================================= #
  HEIGHT = '50%'

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = :dejavu_condensed_22

  # ========================================================================= #
  # === Gtk::XpmLoader::DEFAULT_XPM_TO_USE
  #
  # This constant designates the default XPM that can be used.
  # ========================================================================= #
  DEFAULT_XPM_TO_USE = [
    '10 10 3 1', 
    "   c None", 
    ".  c #FE0B0B",
    "+  c #FFFFFF",
    '+.......++',   
    "+..    ..+",
    "+.. xs  ..+",
    "+..   ...+",
    "+.......++",
    "+.....++++",
    "+..++..+++",
    "+..++...++",
    "+..+++...+",
    "+..++++..+"
  ]

  # ========================================================================= #
  # === initialize
  #
  # location_of_file_to_load can be a .png or whatever we will
  # use imagemagick to convert it.
  # ========================================================================= #
  def initialize(
      location_of_file_to_load = DEFAULT_XPM_TO_USE,
      run_already              = true
    )
    super(:vertical)
    reset
    set_location_of_file_to_load(
      location_of_file_to_load
    )
    @xpm_image = GdkPixbuf::Pixbuf.new(
      xpm: @location_of_file_to_load
    )
    @scaled = @xpm_image.scale(250, 350, :hyper)
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    infer_the_namespace
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, namespace?]
    title_width_height_font(TITLE, WIDTH, HEIGHT, USE_THIS_FONT)
    use_gtk_paradise_project_css_file
    infer_the_size_automatically
  end

  # ========================================================================= #
  # === set_location_of_file_to_load
  # ========================================================================= #
  def set_location_of_file_to_load(
      i
    )
    if i.is_a? Array
      i = i.join
    end
    case i.to_s
    when '1'
      i = '/Depot/j/x.xpm'
    when nil,''
      i = DEFAULT_XPM_TO_USE
    end
    @location_of_file_to_load = i
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === favicon?
  # ========================================================================= #
  def favicon?(i = ENV['IMG'])
    i.to_s+'/games/TETRIS/TETRIS_FAVICON.png'
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === create_skeleton                                          (create tag)
  # ========================================================================= #
  def create_skeleton
    @gtk_image = gtk_image(@scaled)
  end

  # ========================================================================= #
  # === connect_skeleton                                        (connect tag)
  # ========================================================================= #
  def connect_skeleton
    abort_on_exception
    add_or_append(@gtk_image)
    show_all
  end

  # ========================================================================= #
  # === run                                                         (run tag)
  # ========================================================================= #
  def run
    super()
  end

  # ========================================================================= #
  # === Gtk::XpmLoaderModule.run
  # ========================================================================= #
  def self.run(
      i = ARGV
    )
    require 'gtk_paradise/run'
    _ = ::Gtk::XpmLoader.new(i)
    r = ::Gtk.run
    r << _
    r.set_background :white
    r.set_size_request(_.width?, _.height?)
    r.determine_the_title_from_the_child_widget
    r.top_left_then_run
  end

  # ========================================================================= #
  # === Gtk::XpmLoaderModule.run_gtk4
  # ========================================================================= #
  def self.run_gtk4(i = ARGV)
    ::Gtk.default_application('xpm.loader') {{
      widget_to_use: ::Gtk::XpmLoader.new
    }}
  end

end; end