#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# http://localhost/programming/ruby/src/gtk_paradise/lib/gtk_paradise/www/index.cgi
# =========================================================================== #
require 'sinatra'
require 'cyberweb/autoinclude'
require 'roebe/documentation/documentation.rb'
require 'gtk_paradise/project/project.rb'

german('GTK-Paradise index') {
default_template
ruby_favicon
body_css_class 'mar0px pad0px VERDANAs'
body_css_style 'background-color: #d3d2d1;'
default_font_size
  
smaller_width('mar4px pad4px') {
  target_dir = File.absolute_path("#{__dir__}/../../../..")+'/roebe/lib/roebe/documentation/'
  h1 'Index for '+target_dir,
     'martb2px'
  all_files = Dir[target_dir+'*.rb'].select {|entry| File.file? entry }
  all_files.each {|entry|
    symbol = File.basename(entry).delete_suffix('.rb').to_sym
    require 'roebe/documentation/'+File.basename(entry)
    if Roebe::Documentation.respond_to?(symbol)
      addnl(
        Roebe::Documentation.send(symbol)
      )
    end
  }

}}