#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file stores .xbm files, via a submodule.
#
# Note that this isn't quite as much in use as it was in, say, the year
# 2002. In fact: the gtk_paradise gem does not even require this file by
# default anymore, as of November 2023.
#
# Listing of the content so far in this file:
# 
#   Gtk::XbmIcons::XBM_SWORD_ICON
#   Gtk::XbmIcons::BOOK_CLOSED_XPM
#   Gtk::XbmIcons::BOOK_OPENED_XPM
#
# =========================================================================== #
module Gtk

module XbmIcons # === Gtk::XbmIcons

  # ========================================================================= #
  # Next, some XPM Icons.
  # ========================================================================= #

  # ========================================================================= #
  # === XBM_SWORD_ICON
  #
  # To see this file, try:
  #
  #   puts Gtk::XbmIcons::XBM_SWORD_ICON
  #
  # ========================================================================= #
  XBM_SWORD_ICON = [   
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x40,
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
    0x04, 0x00, 0x00, 0x00, 0x10, 0x07, 0x00, 0x00, 0x00, 0xc0, 0x02, 0x00,
    0x00, 0x00, 0x60, 0x01, 0x00, 0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0x00,
    0x78, 0x03, 0x00, 0x00, 0x00, 0x58, 0x07, 0x00, 0x00, 0x00, 0x00, 0x0e,
    0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00,
    0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00,
    0xe0, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00
  ].pack('c*')

  # ========================================================================= #
  # === BOOK_OPENED_XPM
  # ========================================================================= #
  BOOK_OPENED_XPM = [
    "16 16 4 1",
    "       c None s None",
    ".      c black",
    "X      c #808080",
    "o      c white",
    "                ",
    "  ..            ",
    " .Xo.    ...    ",
    " .Xoo. ..oo.    ",
    " .Xooo.Xooo...  ",
    " .Xooo.oooo.X.  ",
    " .Xooo.Xooo.X.  ",
    " .Xooo.oooo.X.  ",
    " .Xooo.Xooo.X.  ",
    " .Xooo.oooo.X.  ",
    "  .Xoo.Xoo..X.  ",
    "   .Xo.o..ooX.  ",
    "    .X..XXXXX.  ",
    "    ..X.......  ",
    "     ..         ",
    "                "
  ]

  # ========================================================================= #
  # === BOOK_CLOSED_XPM
  #
  # This icon represents a closed book.
  # ========================================================================= #
  BOOK_CLOSED_XPM = [
    "16 16 6 1",
    "       c None s None",
    ".      c black",
    "X      c red",
    "o      c yellow",
    "O      c #808080",
    "#      c white",
    "                ",
    "       ..       ",
    "     ..XX.      ",
    "   ..XXXXX.     ",
    " ..XXXXXXXX.    ",
    ".ooXXXXXXXXX.   ",
    "..ooXXXXXXXXX.  ",
    ".X.ooXXXXXXXXX. ",
    ".XX.ooXXXXXX..  ",
    " .XX.ooXXX..#O  ",
    "  .XX.oo..##OO. ",
    "   .XX..##OO..  ",
    "    .X.#OO..    ",
    "     ..O..      ",
    "      ..        ",
    "                "
  ]

  # ========================================================================= #
  # To use these images, try something like this:
  #
  #   @book_open, @book_open_mask     = Gdk::Pixmap.create_from_xpm_d(@notebook.window, nil, $book_open_xpm)
  #   @book_closed, @book_closed_mask = Gdk::Pixmap.create_from_xpm_d(@notebook.window, nil, $book_closed_xpm)
  #
  # ========================================================================= #

end; end