#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/test/gtk3/testing_base_module.rb'
# Gtk::Test.new
# =========================================================================== #
require 'gtk3'

module Gtk

require 'gtk_paradise/requires/require_the_base_module.rb'

class Test < ::Gtk::BaseModuleBox # === Gtk::Test

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:horizontal)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset                                                     (reset tag)
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    append_these_CSS_rules '.bblack20 { border: 20px solid black; }'
    apply_the_default_css_rules
    set_width('90%')
    set_height('80%')
    set_my_title('This is a simple test for Gtk::BaseModule')
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    label = button('Hello world!!!')
    label.clear_background
    label.css_class('steelblue')
    label.css_class('bblack20')
    label.pad5px
    label.make_bold
    label.on_clicked {
      e ::Colours.steelblue(label.text?)
    }
    label.on_hover_tomato
    add(label)
    display_the_CSS_rules
    # store_the_CSS_rules_into_a_local_file # If we want to store this.
  end

end; end

if __FILE__ == $PROGRAM_NAME
  window = Gtk::Window.new
  test = Gtk::Test.new
  window.add(test)
  window.show_all
  window.move(0, 0)
  window.set_border_width(20)
  window.set_size_request(800, 300)
  window.automatically_determine_the_title(test.my_title?)
  Gtk.main
end