#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This file shall test the HTML-specific tags that are part of
# Gtk::BaseModule. The idea is to be able to translate a .cgi or
# sinatra-app into a ruby-gtk representation, aka to use it as
# a cross-GUI DSL one day.
# =========================================================================== #
# require 'gtk_paradise/test/testing_the_html_pseudo_tags.rb'
# =========================================================================== #
require 'gtk_paradise/require_gtk3'
require 'gtk_paradise/run'

class TestingTheHtmlPseudoTags < ::Gtk::Box

  require 'gtk_paradise/requires/require_the_base_module.rb'
  include ::Gtk::BaseModule

  # ========================================================================= #
  # === NAMESPACE
  # ========================================================================= #
  NAMESPACE = inspect

  # ========================================================================= #
  # === USE_THIS_FONT
  # ========================================================================= #
  USE_THIS_FONT = 'Dejavu Sans Mono 22'

  # ========================================================================= #
  # === initialize
  # ========================================================================= #
  def initialize(
      run_already = true
    )
    super(:vertical)
    reset
    run if run_already
  end

  # ========================================================================= #
  # === reset
  # ========================================================================= #
  def reset
    reset_the_internal_variables
    # ======================================================================= #
    # === @configuration
    # ======================================================================= #
    @configuration = [true, __dir__, NAMESPACE]
    use_gtk_paradise_project_css_file 
    infer_the_size_automatically
    this_font = to_font_description(USE_THIS_FONT)
    override_font(this_font)
    set_border_width(10) if respond_to? :set_border_width
  end

  # ========================================================================= #
  # === padding?
  # ========================================================================= #
  def padding?
    4
  end

  # ========================================================================= #
  # === border_size?
  # ========================================================================= #
  def border_size?
    2
  end

  # ========================================================================= #
  # === run
  # ========================================================================= #
  def run
    left_aligned_text1 = left_aligned_text('We will next test various HTML-related tags.')
    minimal(left_aligned_text1)
    add(
      left_aligned_text('Note that the various headers (h1, h2 and so forth) will be shown')
    )
    add(
      left_aligned_text('in different colours, if the CSS in use works properly.')
    )
    add(
      div { sbr('Hi there 1') }
    )
    add(
      div { sbr('Hi there 2') }
    )
    # add(
    #   p('mar10px') {
    #     sbr('This is a paragraph with <b>margin: 10px</b>.')
    #   }
    # )
    # ^^^ this variant does not yet work.
    add(
      h1 'Testing h1', 'darkblue'
    )
    add(
      h2 'Testing h2', 'darkgreen'
    )
    add(
      h3 'Testing h3', 'lightblue'
    )
    add(
      h4 'Testing h4', 'lightgreen'
    )
    add(
      h5 'Testing h5', 'crimson'
    )
    add(
      h6 'Testing h6', 'tomato'
    )
    add(
      h1 'Testing h1 again, with a darkgreen colour', 'darkgreen'
    )
  end

end

if __FILE__ == $PROGRAM_NAME
  _ = TestingTheHtmlPseudoTags.new
  r = Gtk.run
  r.override_font(Pango::FontDescription.new('Dejavu Sans Mono 25'))
  r << _
  r.show_all
  r.top_left_then_run
end