#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/html_colours/hash_html_colours.rb'
# Colours.array_html_colours?
# =========================================================================== #
module Colours

module HtmlColours # === Colours::HtmlColours

  require 'colours/requires/require_yaml.rb'
  require 'colours/constants/constants.rb'

  # ========================================================================= #
  # === @dataset
  #
  # This must be a Hash at all times.
  # ========================================================================= #
  @dataset = {}

  # ========================================================================= #
  # === Colours::HtmlColours.dataset?
  # ========================================================================= #
  def self.dataset?
    @dataset
  end; self.instance_eval { alias main_hash?         dataset? } # === Colours::HtmlColours.main_hash?
       self.instance_eval { alias hash_html_colours? dataset? } # === Colours::HtmlColours.hash_html_colours?

  # ========================================================================= #
  # === Colours::HtmlColours.load_the_dataset_containing_the_html_colours (load tag)
  #
  # This method can be used to load all registered HTML-colours, from a
  # yaml file.
  #
  # The colours in the yaml file are stored in a
  #
  #     name: hexvalue
  #
  # format.
  # ========================================================================= #
  def self.load_the_dataset_containing_the_html_colours(
      use_this_file = ::Colours.file_html_colours
    )
    if File.exist? use_this_file
      @dataset = YAML.load_file(use_this_file)
    else
      # ===================================================================== #
      # The second check is not ideal but I think that I only need this
      # on my home system anyway.
      # ===================================================================== #
      if ("#{ENV['IS_ROEBE']}" == '1')
        puts "Colours::HtmlColours: We could not find any "\
             "file at `#{_}`."
      end
    end
  end

  # ========================================================================= #
  # Always try to load the dataset whenever this file is required.
  # ========================================================================= #
  ::Colours::HtmlColours.load_the_dataset_containing_the_html_colours

  # ========================================================================= #
  # === Colours::HtmlColours.does_include?
  #
  # This method will return true if the given input is included in the
  # HTML colours.
  #
  # Usage examples:
  #
  #   Colours::HtmlColours.does_include? 'slateblue'                 # => true
  #   Colours::HtmlColours.is_this_html_colour_included? 'royalblue' # => true
  #   Colours::HtmlColours.is_this_html_colour_included? 'megawhite' # => false
  #
  # ========================================================================= #
  def self.does_include?(
      i = :slateblue
    )
    return true if @dataset.has_key?(i.to_s)
    false # else return false.
  end; self.instance_eval { alias is_this_html_colour_included? does_include? } # === Colours::HtmlColours.is_this_html_colour_included?
       self.instance_eval { alias is_a_html_colour?             does_include? } # === Colours::HtmlColours.is_a_html_colour?
       self.instance_eval { alias is_a_HTML_colour?             does_include? } # === Colours::HtmlColours.is_a_HTML_colour?
       self.instance_eval { alias is_this_a_html_colour?        does_include? } # === Colours::HtmlColours.is_this_a_html_colour?
       self.instance_eval { alias html_colours_include?         does_include? } # === Colours::HtmlColours.html_colours_include?
       self.instance_eval { alias include_this_html_colour?     does_include? } # === Colours::HtmlColours.include_this_html_colour?
       self.instance_eval { alias is_this_a_valid_html_colour?  does_include? } # === Colours::HtmlColours.is_this_a_valid_html_colour?
       self.instance_eval { alias is_this_input_a_html_colour?  does_include? } # === Colours::HtmlColours.is_this_input_a_html_colour?
       self.instance_eval { alias has_colour?                   does_include? } # === Colours::HtmlColours.has_colour?
       self.instance_eval { alias registered_colour?            does_include? } # === Colours::HtmlColours.registered_colour?

  # ========================================================================= #
  # === Colours::HtmlColours.available_html_colours?
  #
  # This method will return an Array containing all available
  # HTML colours.
  # ========================================================================= #
  def self.available_html_colours?
    @dataset.keys
  end; self.instance_eval { alias all?                    available_html_colours? } # === Colours::HtmlColours.all?
       self.instance_eval { alias html_colours            available_html_colours? } # === Colours::HtmlColours.html_colours
       self.instance_eval { alias return_all_html_colours available_html_colours? } # === Colours::HtmlColours.return_all_html_colours
       self.instance_eval { alias all_colours             available_html_colours? } # === Colours::HtmlColours.all_colours
       self.instance_eval { alias all_colours?            available_html_colours? } # === Colours::HtmlColours.all_colours?
       self.instance_eval { alias colours?                available_html_colours? } # === Colours::HtmlColours.colours?
       self.instance_eval { alias colours                 available_html_colours? } # === Colours::HtmlColours.colours
       self.instance_eval { alias registered_colours?     available_html_colours? } # === Colours::HtmlColours.registered_colours?
       self.instance_eval { alias all_html_colours?       available_html_colours? } # === Colours::HtmlColours.all_html_colours?
       self.instance_eval { alias all_html_colours        available_html_colours? } # === Colours::HtmlColours.all_html_colours

end

# =========================================================================== #
# === Colours.hash_html_colours?
#
# Query-method to return the Hash containing all HTML colours, including
# their respective RGB values.
# =========================================================================== #
def self.hash_html_colours?
  ::Colours::HtmlColours.hash_html_colours?
end

# =========================================================================== #
# === Colours.does_include?
#
# Usage examples:
#
#   Colours.does_include? 'slateblue'
#   Colours.is_this_html_colour_included? 'royalblue' # => true
#   Colours.is_this_html_colour_included? 'megawhite' # => false
#
# =========================================================================== #
def self.does_include?(i = :slateblue)
  i = i.to_sym unless i.is_a? Symbol
  ::Colours::HtmlColours.does_include?(i)
end; self.instance_eval { alias is_this_html_colour_included? does_include? } # === Colours.is_this_html_colour_included?
     self.instance_eval { alias is_a_html_colour?             does_include? } # === Colours.is_a_html_colour?
     self.instance_eval { alias is_a_HTML_colour?             does_include? } # === Colours.is_a_HTML_colour?
     self.instance_eval { alias is_this_a_html_colour?        does_include? } # === Colours.is_this_a_html_colour?
     self.instance_eval { alias html_colours_include?         does_include? } # === Colours.html_colours_include?
     self.instance_eval { alias include_this_html_colour?     does_include? } # === Colours.include_this_html_colour?
     self.instance_eval { alias is_this_a_valid_html_colour?  does_include? } # === Colours.is_this_a_valid_html_colour?
     self.instance_eval { alias is_this_input_a_html_colour?  does_include? } # === Colours.is_this_input_a_html_colour?
     self.instance_eval { alias has_colour?                   does_include? } # === Colours.has_colour?
     self.instance_eval { alias registered_colour?            does_include? } # === Colours.registered_colour?

# =========================================================================== #
# === Colours.available_html_colours?
# =========================================================================== #
def self.available_html_colours?
  ::Colours::HtmlColours.available_html_colours?
end; self.instance_eval { alias html_colours?           available_html_colours? } # === Colours.html_colours?
     self.instance_eval { alias html_colours            available_html_colours? } # === Colours.html_colours
     self.instance_eval { alias all_html_colours        available_html_colours? } # === Colours.all_html_colours
     self.instance_eval { alias return_all_html_colours available_html_colours? } # === Colours.return_all_html_colours
     self.instance_eval { alias colours?                available_html_colours? } # === Colours.colours?
     self.instance_eval { alias colours                 available_html_colours? } # === Colours.colours
     self.instance_eval { alias registered_colours?     available_html_colours? } # === Colours.registered_colours?
     self.instance_eval { alias array_html_colours?     available_html_colours? } # === Colours.array_html_colours?

end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  dataset = Colours::HtmlColours.dataset?
  pp dataset
end