#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'check_for_trollop_being_available_or_exit.rb'
# =========================================================================== #
module Colours

module RainbowColours

  require 'colours/rainbow_colours/print_rainbow_line.rb'

  # ========================================================================= #
  # === Colours::RainbowColours.check_for_trollop_being_available_or_exit
  # ========================================================================= #
  def self.check_for_trollop_being_available_or_exit
    # ======================================================================= #
    # First check whether the user has the Trollop gem installed.
    # ======================================================================= #
    unless Object.const_defined? :Trollop
      e
      e 'Trollop is not installed. Please install it via:'
      e
      e '  gem install trollop'
      e
      exit
    end
  end

end; end