#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/rainbow_colours/println_plain.rb'
# =========================================================================== #
module Colours

module RainbowColours

  require 'colours/rainbow_colours/returnln_plain.rb'

  # ========================================================================= #
  # === Colours::RainbowColours.println_plain
  #
  # This method will colourize the given input line.
  #
  # Usage example:
  #
  #   Colours::RainbowColours.println_plain
  #   Colours::RainbowColours.println_plain 'one two three four five six seven eight'
  #
  # ========================================================================= #
  def self.println_plain(
      str      = "Hello world! Good morning sunshine.\n",
      defaults = {},
      opts     = {
        spread:    DEFAULT_RAINBOW_SPREAD,
        os:        rand(256),
        truecolor: true
      }
    )
    print returnln_plain(str, defaults, opts)
  end

end; end