#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Colours
# =========================================================================== #
# require 'colours/toplevel_methods/e.rb'
# =========================================================================== #
module Colours

  # ========================================================================= #
  # === Colours.e
  #
  # This is essentially just a fancified wrapper over puts.
  #
  # Usage examples:
  #
  #   Colours.e 'hello world'
  #   Colours.e "hi \n there\n is everything fine? \n\n"
  #
  # ========================================================================= #
  def self.e(
      i              = N,
      append_newline = true
    )
    i = i.join(' ') if i.is_a? Array
    _ = "#{rev}#{i.to_s.dup}".dup # Work with a copy here.
    _.chomp! # So that we won't have more than one newline initially.
    _ << N if append_newline # This should be the last modification before calling print.
    print _ # And print the result finally.
  end

  # ========================================================================= #
  # === e                                                             (e tag)
  #
  # This is just a wrapper towards the above method called Colours.e()
  #
  # If the second argument `make_newline` is true then we will append a
  # newline. This is the default behaviour.
  #
  # This method just delegates to the module method Colours.e()
  # ========================================================================= #
  def e(
      i              = N,
      append_newline = true
    ) # This is the main point of Colours.
    ::Colours.e(i, append_newline) # Point towards the class method of e().
  end; alias ci e # === ci

  # ========================================================================= #
  # === ef
  # ========================================================================= #
  def ef(i)
    e(i, false) # The variant without newlines.
  end

end

if __FILE__ == $PROGRAM_NAME
  if ARGV.empty?
    Colours.e('Hello World!')
  else
    Colours.e(ARGV)
  end
end