#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/toplevel_methods/map_this_symbol_to_that_html_colour.rb'
# =========================================================================== #
module Colours

  # ========================================================================= #
  # === Colours.map_this_symbol_to_that_html_colour
  #
  # The job of this method is to map entries such as :bold_green to
  # a corresponding HTML colour.
  # ========================================================================= #
  def self.map_this_symbol_to_that_html_colour(i)
    if is_a_html_colour? i
      i
    else
      case i
      # ===================================================================== #
      # === :cyanb
      # ===================================================================== #
      when :cyanb
        :lightseagreen
      # ===================================================================== #
      # === :light_grey
      # ===================================================================== #
      when :light_grey
        :lightgray
      # ===================================================================== #
      # === :bold_blue
      # ===================================================================== #
      when :bold_blue
        :slateblue
      # ===================================================================== #
      # === :bold_red
      # ===================================================================== #
      when :bold_red, :redb
        :crimson
      # ===================================================================== #
      # === :bold_yellow
      # ===================================================================== #
      when :bold_yellow
        :goldenrod
      # ===================================================================== #
      # === :bold_green
      # ===================================================================== #
      when :bold_green
        :seagreen
      else
        puts 'Unregistered input into the method '+__method__.to_s+': '+i.to_s
        return i # We'll still return that input, though.
      end
    end
  end

end