#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'colours/toplevel_methods/rev.rb'
# =========================================================================== #
module Colours

  # ========================================================================= #
  # === @revert
  #
  # We need a variable here in order to be able to change this.
  # ========================================================================= #
  @revert = "\e[0;37m"

  # ========================================================================= #
  # === Colours.set_revert
  # ========================================================================= #
  def self.set_revert(
      i = :default
    )
    case i
    # ======================================================================= #
    # === :default
    # ======================================================================= #
    when :default
      i = REVERT
    end
    @revert = i
  end

  # ========================================================================= #
  # === Colours.rev
  #
  # We use this method to revert to the old default, that is, the prior
  # state for ANSI colours. It should be equivalent to: "\x1b[0m" e. g.
  # REVERT = "\x1b[0m" # "\x1b[39;49m" <--- This here seems to fail for Konsole.underline, though.
  #
  # An alternative could be DEFAULT_COLOUR.
  # ========================================================================= #
  def self.rev
    # REVERT # <- This used to be: "\e[0;37m"
    @revert # This is light white. I prefer this colour actually.
  end; self.instance_eval { alias revert   rev } # === Colours.revert
       self.instance_eval { alias revert?  rev } # === Colours.revert?
       self.instance_eval { alias restore? rev } # === Colours.restore?

  # ========================================================================= #
  # === rev
  #
  # Use this method to "revert" to the old default colour again, by
  # delegating towards the Colours.rev() method defined above.
  #
  # From this point on, we use methods that can be toggled.
  # ========================================================================= #
  def rev(i = '')
    ::Colours.rev # This will refer to the Colours.rev() module method.
  end; alias revert rev # === revert
       # alias default_colour rev

end