#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# The test-code resides in colours/lib/colours/test.rb so we can just
# call Colours.test
# =========================================================================== #
if __FILE__ == $PROGRAM_NAME

  require 'colours/autoinclude'
 
  alias ee print

  # ========================================================================= #
  # === cliner
  # ========================================================================= #
  def cliner
    ::Colours.cliner
  end

  # ========================================================================= #
  # === Testing Colours.ecomment() next
  # ========================================================================= #
  cliner
  e 'This file will test the colour gem.'
  e
  e 'Next, this file will test for the method Colours.ecomment()'
  e 'being able to process multiple lines in one go:'
  cliner
  ::Colours.ecomment '

  --ncards?               # How many cards are available
                          # ^^^ If you pass an argument, then we will use that as name for the card set.
  merge in all yaml files # To merge in all yaml files
  html                    # To generate the .html page
  zip                     # To create a big .zip file

'

  # cliner # <-- This cliner is superfluous because Colours.test() will already show one.
  e 'Next, Colours.test() will be invoked:'
  e
  Colours.test # Invoke the Colours.test() class method.
  e Colours.bold_white('This text here should be in bold white.')
  cliner
  e 'Next testing Colours::AnsiColours'
  i = "08.01.2015, 01:16:25 \e[1;32mNo registered users\e[0;0m\e[0;37m."
  e 'Available colours:'
  Colours::ARRAY_REGISTERED_ANSI_COLOURS.each {|colour|
    e colour.inspect+' '+colour+'<- Colourtest.'
  }
  e 'Next we will test a string with AnsiEscape sequences.'
  e 'We wish to get rid of them.'
  pp i
  ee '(1) '
  e Colours.remove(i)
  ee '(2) '
  e i.gsub(REMOVE_ANSI_ESCAPE_CHARACTERS, '') # This regex also works.
  e Colours::TEAL+'Teal'+Colours::REVERT
  # ========================================================================= #
  # === Next test the HtmlColours submodule
  # ========================================================================= #
  cliner
  e 'Next testing the html colours subcomponent of module Colours:'
  e 'Featuring '+simp('Colours::HtmlColours.sample')+' next:'
  e Colours::HtmlColours.sample
  e
  e Colours::HtmlColours::HTML_COLOURS.size
  pp Colours::HtmlColours[]
  cliner
  # ========================================================================= #
  # === Next test the old ColourAid module
  # ========================================================================= #
  cliner
  e 'Hello World! We will now test sfancy() simp() swarn() and ssymlink():'
  cliner
  e 'How do you '+Colours.sfancy('do')+'?'
  e 'How do you '+Colours.simp('do')+'?'
  e 'How do you '+Colours.swarn('do')+'?'
  e 'How do you '+Colours.ssymlink('do')+'?'
  cliner
  e 'How do you '+sfancy('do')+'?'
  e 'How do you '+simp('do')+'?'
  e 'How do you '+swarn('do')+'?'
  e 'How do you '+ssymlink('do')+'?'
  cliner
  e 'Next testing efancy(), eimp(), ewarn() and esymlink().'
  efancy 'All is fine.'
  eimp 'You are doing great!'
  ewarn 'Red Alert!'
  esymlink 'yo there'
  e 'Next, we will test Colours.eparse()'
  Colours.eparse(' - s[number]  # start to cut at this '\
  'start-position in seconds - example: s5')
  e Colours.fancy_parse('<lightgreen><i>E. coli</i></lightgreen>')
end # test_colours