#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
require 'colours/html_colours'

alias e puts

use_this_hash = {
  one:            :steelblue,
  two:            :mediumseagreen,
  three:          :mediumpurple,
  four:           :olivedrab,
  five:           :lightgreen,
  default_colour: :olivedrab
}
x = 'Contemporary <royalblue>research</royalblue> in animal cognition has as '\
    'its roots ... where? In <one>Charles Darwin’s theory of evolution by natural selection</one>.'

e
e x
e
y = Colours.replace_number_words_with_the_corresponding_html_colour(x, use_this_hash)
e
e y
e

z = '- Is <one>abc</one> <two>an example of</two> <orange>def ghi</orange> or of <orange>jkl mno</orange>? <one>Non-associative learning</one>.'
scanned = z.scan(
  Colours::REGEX_FOR_HTML_COLOURS
).flatten.uniq
scanned.each {|entry|
  if Colours.is_a_HTML_colour?(entry) # Here we know it is a HTML colour.
    e z+::Colours.rev
    colour_to_use = Colours.replace_number_words_with_the_corresponding_html_colour(entry, use_this_hash)
    regex_to_use = Colours.return_main_regex_to_use_for_obtaining_the_full_content(colour_to_use)
    e z.gsub(
      regex_to_use,
      ::Colours.send(colour_to_use.to_sym, "\\1")       { :omit_end }+
      ::Colours.rev
    )
  end
}
#e z
# y = Colours.replace_number_words_with_the_corresponding_html_colour(x, use_this_hash)