#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# This .rb file will also text the extensive test suite that I am using
# to make sure the colourization parts work.
# =========================================================================== #
require 'colours/toplevel_methods/methods_related_to_html_colours.rb'
require 'colours/html_colours/html_colours.rb'

result = <<-EOF
- Is <one>abc</one> <two>an example of</two> <orange>def ghi</orange> or of <orange>jkl mno</orange>? <one>Non-associative learning</one>.
<orange>C₅|H₁₀₀|N₂|O</orange>
<orange>C₆|H₁₄|N₂|O₂</orange>
<orange>H₂CO₃</orange>
<orange>α-aminogruppe</orange>
<orange>Mg²⁺</orange>
<orange>„Write once, run everywhere.“</orange>.
<orange>5'→3'</orange>yo
ist <orange>a @ b</orange> eine valide Anweisung?
<orange>x^2 + 1 = 0⁺</orange>
<orange>yo there</orange>
<orange>Antigen-Antikörper</orange>
<orange>Antigen-Antikörper</orange>
For the production of recombinant antibodies, we may use <orange>₂₃₄library display methods</orange>.
C3-Pflanzen fixieren ... <orange>CO²</orange>
<orange>4 ≥ 3</orange>
<orange>item -> { }</orange>
In <orange>Charles Darwin’s theory of evolution by natural selection</orange>.
<orange>catch (...) { cout << 42; }</orange>
<orange>₁₂₃₄₅₆₇₈₉⁰¹²³⁴⁵⁶⁷⁸⁹</orange>
<orange>[]</orange>
<orange>| |</orange>
<orange>last shared_ptr to it is destroyed</orange>
<orange>Process.uid.zero?</orange>
<orange>"UGA"Å</orange>
<orange>2:1 ratio</orange>
<orange>3-O-β-D-galactose</orange>
<orange>open(foobar.txt);</orange>
<orange>open("foobar.txt")</orange>
<orange>open("foobar.txt");</orange>
<orange>Huber’s pigeon lab.</orange>
<orange>Carl von Linné</orange>
<orange>Tú frog</orange>
<orange>(3x10²) + (2x10¹) + (7x10⁰)</orange>
<orange>10∨³⁰</orange>
<orange>10³⁰</orange>
<orange>n μm in diameter</orange>
<orange>10-20 μm in diameter</orange>
<orange>⁻¹²</orange>
<orange>+αβÅ</orange>
<orange>+</orange>
<orange>Maximale Trennungsgröße</orange>
<orange>++foo</orange>
<orange>300.000</orange>
<orange>50°C</orange>
<orange>1g/kg Körpergewicht</orange>
<orange>foobar = { 1, 5, 9, 3, 6, 2 }</orange>
<orange>a = b;</orange>
foo? <orange>4-10 per cell</orange>
- foo <orange>ok</orange>
<orange>60%</orange>
<orange>operative Geschäft</orange>
<orange>C -> U</orange>
<orange>"ok again"</orange>  <green>yere</green>  
<orange>ok</orange>"? ok
<orange>rint(f.read(5))</orange>
<orange># => 3</orange>
<orange>&</orange>
<orange>int *x;</orange>
<orange>a single F(ab)2 fragment</orange>
<orange>¹⁸F.</orange>
<orange>~70x</orange>
<orange>!=</orange>
Üowohl +0 sowie -0. Bei Vergleichen ... <orange>+0 = −0</orange>.
<orange>3' OH Gruppe</orange>
<orange>f = open("foobar.txt", "r");</orange>
Dies ist <orange>xeee, aaa, prognostische, x "precision medicine"</orange>, die zudem ...
<orange>-C≡N</orange>
<orange>NOAEL</orange> und <orange>LOEL</orange>
<orange>'\0'</orange>
The female <orange>Túngara frog</orange> will select males that show ...
EOF

USE_THIS_COLOUR_FOR_THE_DEFAULT_COLOUR = :grey

result = result.split("\n").reject {|entry| entry.strip.empty? }
result.each {|this_line|
  this_line = this_line.dup if this_line.frozen?
  scanned_results = this_line.scan(
    Colours::REGEX_FOR_HTML_COLOURS
  ).flatten.uniq
  scanned_results.each {|this_colour|
    if Colours.is_this_a_valid_html_colour?(this_colour)
      use_this_regex = 
        Colours.return_main_regex_to_use_for_obtaining_the_full_content(this_colour)
      # =================================================================== #
      # We must use .gsub!() because the colour-string may occur more 
      # than once. Unfortunately for longer Strings this becomes a bit
      # fragile.
      # =================================================================== #
      part1 = ::Colours::AllColourMethods.send(this_colour.to_sym, "\\1") { :omit_end }
      part2 = ::Colours::AllColourMethods.send(USE_THIS_COLOUR_FOR_THE_DEFAULT_COLOUR) { :omit_end }
      this_line.gsub!(
        use_this_regex,
        part1+
        part2
      ).dup
    end
  }
  puts ::Colours.rev+this_line
}