# =========================================================================== #
# Gemspec for Project gtk_paradise.
# =========================================================================== #
require 'gtk_paradise/version/version.rb'
require 'roebe/toplevel_methods/misc.rb'

Gem::Specification.new { |s|

  s.name    = 'gtk_paradise'
  s.version = Gtk::VERSION_OF_THE_GTK_PARADISE_PROJECT
  s.date    = Time.now.strftime('%Y-%m-%d')

  DESCRIPTION = <<-EOF

This library is called gtk_paradise (release saga 0.12.x), the
successor to the older gtk_module project.

The gtk_paradise library extends the Gtk/Gdk part of ruby-gtk -
in particular for ruby-gtk3.

The central idea powering this gem is to make the ruby-gtk bindings
more "ruby-like" rather than retain them to be a 1:1 mapping to 
the underlying C source code.

The custom widgets bundled into this gem are an attempt to further
make working with the ruby-gtk bindings easier. That way, the
time investment by users of this gem is reduced, such as when
they wish to create new applications and new projects from
scratch.

This project is still rather beta-ish, though. APIs may change
a lot, still - do not expect stability for the time being. It is
not recommend to use this project in production yet, unless you 
are willing to see things potentially break all over everywhere,
every now and then. Long-term stability is planned in the long
run, though. Once achieved it will be announced on the README.md
as well as enter the 1.0.x release series.

For more information pertaining to this project, please have a
look at the documentation for this gem, at:

https://www.rubydoc.info/gems/gtk_paradise/

  EOF

  s.summary     = DESCRIPTION
  s.description = DESCRIPTION

  # ========================================================================= #
  # Show this when a user installs this project.
  # ========================================================================= #
  s.post_install_message = <<-EOF

Make sure to have the ruby-gtk bindings (the gtk3 gem and optionally the 
gtk2 gem as well) available before you attempt to use this collection
of snippets/code.

This should be doable via:

    gem install gtk3
    gem install gtk2
    gem install gtk4

Make sure to have the required headers/devel-packages installed for gtk3 or
gtk2 respectively. The main focus is on ruby-gtk3 these days, so ruby-gtk2
is mostly in legacy-support mode (but still available in gtk_paradise).

  EOF

  s.authors  = ['Robert A. Heiler']
  s.email    = Roebe.email?
  s.files    = Dir['**/*']
  s.licenses = 'MIT'
  s.homepage = 'https://rubygems.org/gems/gtk_paradise'

  s.required_ruby_version     = '>= '+Roebe.third_most_stable_version_of_ruby
  s.required_rubygems_version = '>= '+Gem::VERSION
  s.rubygems_version          = '>= '+Gem::VERSION

  # ========================================================================= #
  # Dependencies for the project:
  # ========================================================================= #
  s.add_dependency 'colours'
  # s.add_dependency 'gtk2' # Disabled as of 28.08.2021 as a direct dependency.
  s.add_dependency 'gtk3'

}