#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/base_module/experimental.rb'
# =========================================================================== #
module Gtk

module BaseModule

  # ========================================================================= #
  # === automatically_created_widgets?
  # ========================================================================= #
  def automatically_created_widgets?
    @internal_hash[:automatically_created_widgets]
  end

  # ========================================================================= #
  # === automatically_create_widgets_based_on_this_dataset
  #
  # This method can be specifically used to create some widgets
  # "automatically", based on a description provided by a yaml
  # file (or some other text file).
  #
  # The input to this method should be a Hash, though.
  # ========================================================================= #
  def automatically_create_widgets_based_on_this_dataset(
      i,
      be_verbose = true # Whether to report anything to the user or not.
    )
    # ======================================================================= #
    # Always reset the main pointer, at the least for now:
    # ======================================================================= #
    @internal_hash[:automatically_created_widgets] = {}
    if i.is_a? Hash
      i.each_pair {|key, value|
        case key # case tag
        # =================================================================== #
        # === entries
        # =================================================================== #
        when 'entries'
          entries = {}
          value.each_pair {|inner_key, inner_value|
            use_this_as_the_id = inner_key.to_s
            an_entry = entry
            an_entry.clear_background
            # =============================================================== #
            # === text
            # =============================================================== #
            if inner_value.has_key? 'text'
              an_entry.set_text(inner_value['text'])
            end
            # =============================================================== #
            # === css_class
            # =============================================================== #
            if inner_value.has_key? 'css_class'
              an_entry.use_these_css_classes(
                inner_value['css_class']
              )
            end
            entries[use_this_as_the_id.to_sym] = an_entry
          }
          @internal_hash[:automatically_created_widgets][:entries] = entries
        # =================================================================== #
        # === buttons
        #
        # Handle buttons here.
        # =================================================================== #
        when 'buttons'
          buttons = {}
          value.each_pair {|inner_key, inner_value|
            use_this_as_the_id = inner_key.to_s
            a_button = button
            a_button.clear_background
            # =============================================================== #
            # === text
            # =============================================================== #
            if inner_value.has_key? 'text'
              a_button.set_text(inner_value['text'])
            end
            # =============================================================== #
            # === css_class
            # =============================================================== #
            if inner_value.has_key? 'css_class'
              a_button.use_these_css_classes(
                inner_value['css_class']
              )
            end
            # =============================================================== #
            # Buttons always respond to on-clicked events.
            # =============================================================== #
            perform_this_action_on_clicked_event = inner_value['on_clicked'].to_sym
            a_button.on_clicked {
              if respond_to?(perform_this_action_on_clicked_event)
                send(perform_this_action_on_clicked_event)
              else
                if be_verbose
                  e "#{rev}No method called "\
                    "#{tomato(perform_this_action_on_clicked_event)}"\
                    "#{tomato('()')}"\
                    " is defined."
                end
              end
            }
            # buttons[a_button.object_id] = a_button
            buttons[use_this_as_the_id.to_sym] = a_button
          }
          @internal_hash[:automatically_created_widgets][:buttons] = buttons
        else
          e "Unhandled key: #{steelblue(key.to_s)}"
        end
      }
    else
      e 'Please supply a Hash to this method.'
      e 'Presently only a Hash is supported.'
    end
  end

end; end