#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::Colours
#
# Do note that the module here, called Gtk::Colours, will always be
# made available by default, through require() in other .rb files.
# =========================================================================== #
# require 'gtk_paradise/colours/colours.rb'
# include ::Gtk::Colours
# Gtk.convert_gdk_colour_to_gdk_rgba_colour
# =========================================================================== #
# require 'gtk_paradise/colours/gtk_colour_constants.rb'
# =========================================================================== #
module Gtk

require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

# =========================================================================== #
# All add-on colours for Gtk will be gathered here, including convenience
# methods/constants.
# =========================================================================== #
module Colours # === Gtk::Colours

if ::Gtk.use_gtk3?

  require 'gtk_paradise/colours/parse.rb'

  # ========================================================================= #
  # RED   = Gdk::Color.new( 65535, 0, 0 )
  # GREEN = Gdk::Color.new( 0, 65535, 0 )
  # BLUE  = Gdk::Color.new( 0, 0, 65535 )
  # ========================================================================= #

  # ========================================================================= #
  # === PAST THIS POINT, KEEP THE CONSTANTS SORTED ALPHABETICALLY, PLEASE
  #
  # If you wish to use this part with the colours, do this:
  #
  #   include Gtk::Colours
  #
  # Or:
  #
  #   Gtk::Colours::MEDIUMAQUAMARINE
  #   Gtk::Colours::BLACK
  #
  # ========================================================================= #
  ALICEBLUE           = parse 'aliceblue'
  AQUAMARINE          = parse 'aquamarine'
  AZURE               = parse 'azure'
  ANTIQUEWHITE        = parse 'antiquewhite'
  BISQUE              = parse 'bisque'
  BLACK               = parse 'black'
  BROWN               = parse 'brown'
  BLUE                = parse 'blue'
  BLANCHEDALMOND      = parse 'blanchedalmond'
  BEIGE               = parse 'beige'
  BLUEVIOLET          = parse 'blueviolet'
  BURLYWOOD           = parse 'burlywood'
  CORAL               = parse 'coral'
  CADETBLUE           = parse 'cadetblue'
  CHOCOLATE           = parse 'chocolate'
  CORNSILK            = parse 'cornsilk'
  CORNFLOWERBLUE      = parse 'cornflowerblue'
  CYAN                = parse 'cyan'
  CHARTREUSE          = parse 'chartreuse'
  # CRIMSON = parse 'crimson' # Unsure why I removed this here.
  DARKSALMON          = parse 'darksalmon'
  DARKRED             = parse 'darkred'
  DARKGOLDENROD       = parse 'darkgoldenrod'
  DARKKHAKI           = parse 'darkkhaki'
  DARKOLIVEGREEN      = parse 'darkolivegreen'
  DARKSEAGREEN        = parse 'darkseagreen'
  DARKGREEN           = parse 'darkgreen'
  DARKTURQUOISE       = parse 'darkturquoise'
  DARKCYAN            = parse 'darkcyan'
  DEEPSKYBLUE         = parse 'deepskyblue'
  DARKBLUE            = parse 'darkblue'
  DARKGRAY            = parse 'darkgray'
  DARKMAGENTA         = parse 'darkmagenta'
  DARKORCHID          = parse 'darkorchid'
  DARKVIOLET          = parse 'darkviolet'
  DARKORANGE          = parse 'darkorange'
  DARKSLATEGRAY       = parse 'darkslategray'
  DEEPPINK            = parse 'deeppink'
  DIMGRAY             = parse 'dimgray'
  DODGERBLUE          = parse 'dodgerblue'
  DARKSLATEBLUE       = parse 'darkslateblue'
  FIREBRICK           = parse 'firebrick'
  FLORALWHITE         = parse 'floralwhite'
  FORESTGREEN         = parse 'forestgreen'
  GOLD                = parse 'gold'
  GOLDENROD           = parse 'goldenrod'
  GREEN               = parse 'green'
  GREENYELLOW         = parse 'greenyellow'
  GREY                = parse 'grey'
  GAINSBORO           = parse 'gainsboro'
  GHOSTWHITE          = parse 'ghostwhite'
  HOTPINK             = parse 'hotpink'
  HONEYDEW            = parse 'honeydew'
  IVORY               = parse 'ivory'
  INDIANRED           = parse 'indianred'
  # INDIGO = parse 'indigo'
  KHAKI               = parse 'khaki'
  LAVENDERBLUSH       = parse 'lavenderblush'
  LAVENDER            = parse 'lavender'
  LIMEGREEN           = parse 'limegreen'
  LIGHTSALMON         = parse 'lightsalmon'
  LIGHTCORAL          = parse 'lightcoral'
  LIGHTGOLDENRODYELLOW= parse 'lightgoldenrodyellow'
  LIGHTSTEELBLUE      = parse 'lightsteelblue'
  LIGHTPINK           = parse 'lightpink'
  LIGHTSLATEGRAY      = parse 'lightslategray'
  LIGHTGREY           = parse 'lightgrey'
  LIGHTCYAN           = parse 'lightcyan'
  LIGHTBLUE           = parse 'lightblue'
  LIGHTSKYBLUE        = parse 'lightskyblue'
  LIGHTSEAGREEN       = parse 'lightseagreen'
  LAWNGREEN           = parse 'lawngreen'
  # LIME= parse 'lime'
  LIGHTGREEN          = parse 'lightgreen' # Gtk::Colours::LIGHTGREEN
  LINEN               = parse 'linen'
  LIGHTYELLOW         = parse 'lightyellow'
  LEMONCHIFFON        = parse 'lemonchiffon'
  MOCCASIN            = parse 'moccasin'
  MAGENTA             = parse 'magenta'
  MEDIUMBLUE          = parse 'mediumblue'
  MEDIUMORCHID        = parse 'mediumorchid'
  MEDIUMPURPLE        = parse 'mediumpurple'
  MEDIUMAQUAMARINE    = parse 'mediumaquamarine'
  MEDIUMSPRINGGREEN   = parse 'mediumspringgreen'
  MEDIUMSEAGREEN      = parse 'mediumseagreen'
  MEDIUMTURQUOISE     = parse 'mediumturquoise'
  MEDIUMVIOLETRED     = parse 'mediumvioletred'
  MIDNIGHTBLUE        = parse 'midnightblue'
  MINTCREAM           = parse 'mintcream'
  MISTYROSE           = parse 'mistyrose'  
  MEDIUMSLATEBLUE     = parse 'mediumslateblue'
  MAROON              = parse 'maroon'
  NAVAJOWHITE         = parse 'navajowhite'
  NAVY                = parse 'navy'
  OLDLACE             = parse 'oldlace'
  # OLIVE= parse 'olive'
  OLIVEDRAB           = parse 'olivedrab'
  ORANGE              = parse 'orange'
  ORCHID              = parse 'orchid'
  ORANGERED           = parse 'orangered'
  PAPAYAWHIP          = parse 'papayawhip'
  PEACHPUFF           = parse 'peachpuff'
  PALEGREEN           = parse 'palegreen'
  PALEVIOLETRED       = parse 'palevioletred'
  PALETURQUOISE       = parse 'paleturquoise'
  PERU                = parse 'peru'
  PINK                = parse 'pink'
  PLUM                = parse 'plum'
  POWDERBLUE          = parse 'powderblue'
  PURPLE              = parse 'purple'
  PALEGOLDENROD       = parse 'palegoldenrod'
  RED                 = parse 'red'
  ROYALBLUE           = parse 'royalblue'
  ROSYBROWN           = parse 'rosybrown'
  SANDYBROWN          = parse 'sandybrown'
  SALMON              = parse 'salmon'
  SEAGREEN            = parse 'seagreen'
  SEASHELL            = parse 'seashell'
  # SILVER = parse 'silver'
  SKYBLUE             = parse 'skyblue'
  SADDLEBROWN         = parse 'saddlebrown'
  SIENNA              = parse 'sienna'
  STEELBLUE           = parse 'steelblue'
  SPRINGGREEN         = parse 'springgreen'
  SLATEBLUE           = parse 'slateblue' # Gdk::Color.parse('slateblue')
  SNOW                = parse 'snow'
  SLATEGRAY           = parse 'slategray'
  TAN                 = parse 'tan'
  # TEAL = parse 'teal'
  THISTLE             = parse 'thistle'
  TOMATO              = parse 'tomato'
  TURQUOISE           = parse 'turquoise'
  VIOLET              = parse 'violet'
  WHITE               = parse 'white'
  WHITESMOKE          = parse 'whitesmoke'
  WHEAT               = parse 'wheat'
  YELLOW              = parse 'yellow'
  YELLOWGREEN         = parse 'yellowgreen'

end

end

include ::Gtk::Colours

end

if __FILE__ == $PROGRAM_NAME
  pp Gtk::Colours::LAVENDERBLUSH
end