#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/constants/constants.rb'
# =========================================================================== #
module Gtk

  require 'gtk_paradise/project/project.rb'

  # ========================================================================= #
  # === N
  # ========================================================================= #
  N = "\n"

  # ========================================================================= #
  # === FONT_SIZE
  #
  # Uniform default font-size for the whole GUI part. We pick a fairly
  # large font size, so to honour elderly people who may have a
  # decreased vision.
  # ========================================================================= #
  FONT_SIZE = '25'

  # ========================================================================= #
  # === Gtk::USE_THIS_FONT_FAMILY_FOR_GUI_APPLICATIONS
  #
  # Here we specify a certain default font to use for ruby-gtk applications.
  # ========================================================================= #
  USE_THIS_FONT_FAMILY_FOR_GUI_APPLICATIONS =
    'Bitstream Vera Serif' # 'DejaVu Sans Mono'

  # ========================================================================= #
  # === Gtk:::USE_THIS_FONT
  #
  # This is the aggregate constant, based on the two constants defined
  # above. The end-result will be a String such as
  # 'Bitstream Vera Serif 25'.
  # ========================================================================= #
  USE_THIS_FONT =
    "#{USE_THIS_FONT_FAMILY_FOR_GUI_APPLICATIONS} #{FONT_SIZE}"

  # ========================================================================= #
  # === Gtk::PATH_TO_THE_PLUS_SYMBOL_IMAGE
  #
  # This path may resolve to a String such as:
  #
  #   '/usr/lib/ruby/site_ruby/3.2.0/gtk_paradise/images/misc/plus_symbol.png'
  #
  # ========================================================================= #
  PATH_TO_THE_PLUS_SYMBOL_IMAGE =
    "#{project_base_directory?}images/misc/plus_symbol.png"

  # ========================================================================= #
  # === Gtk::PATH_TO_THE_MINUS_SYMBOL_IMAGE
  # ========================================================================= #
  PATH_TO_THE_MINUS_SYMBOL_IMAGE =
    "#{project_base_directory?}images/misc/minus_symbol.png"

  # ========================================================================= #
  # === Gtk::FILE_ARROW_RIGHT
  #
  # This constant refers to a right-arrow image. This can be used if you 
  # need to present to the user where to "click" or look at. In some ways 
  # it is a bit like Gtk::Expander, just as an image, and larger.
  # ========================================================================= #
  FILE_ARROW_RIGHT =
    "#{project_base_directory?}images/misc/ARROW_RIGHT.png"

  # ========================================================================= #
  # === Gtk::FILE_PROJECT_CSS
  # ========================================================================= #
  FILE_PROJECT_CSS =
    "#{project_base_directory?}cascading_style_sheets/project.css"

  # ========================================================================= #
  # === Gtk::FILE_TABBLE
  # ========================================================================= #
  FILE_TABBLE = 
    "#{project_base_directory?}images/misc/tabble.png"

  # ========================================================================= #
  # === Gtk::ARRAY_CSS_FILES
  # ========================================================================= #
  ARRAY_CSS_FILES = 
  [
    "#{project_base_directory?}cascading_style_sheets/project.css",
    "#{project_base_directory?}cascading_style_sheets/colours.css",
    "#{project_base_directory?}cascading_style_sheets/borders.css",
    "#{project_base_directory?}cascading_style_sheets/hover_effects.css"
  ]

  # ========================================================================= #
  # === Gtk::AVAILABLE_CURSORS
  #
  # Specify the available gtk-related cursors.
  # ========================================================================= #
  AVAILABLE_CURSORS = %w(
    x
    arrow
    boat
    down
    up
    bogosity
    left
    right
    side
    tee
    left
    angle
    spiral
    center
    circle
    clock
    mug
    gobbler
    gumby
    hand1
    hand2
    heart
    icon
    iron
    default
    left_side
    left_tee
    leftbutton 
  )

  # ========================================================================= #
  # === Gtk.available_cursors?
  # ========================================================================= #
  def self.available_cursors?
    AVAILABLE_CURSORS
  end

  # ========================================================================= #
  # === Gtk.user_config_dir
  #
  # This method may return a string such as "/root/.config".
  # ========================================================================= #
  def self.user_config_dir
    GLib.user_config_dir
  end

end

if __FILE__ == $PROGRAM_NAME
  alias e puts
  e Gtk::PATH_TO_THE_PLUS_SYMBOL_IMAGE
  e
  pp Gtk::ARRAY_CSS_FILES
  e
  e Gtk.available_cursors?[3]
  require 'gtk3'
  e
  e Gtk.user_config_dir
  e
end