#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/about.rb'
# Gtk.return_about_dialog_widget
# =========================================================================== #
module Gtk

  # ========================================================================= #
  # === Gtk.return_about_dialog_widget
  #
  # This method will create an about-dialog.
  #
  # The arguments are:
  #
  #   (1) the logo to be displayed
  #   (2) the copyright notice to show
  #   (3) the comment to display
  #   (4) the authors (as Array)
  #
  # ========================================================================= #
  def self.return_about_dialog_widget(
      use_this_logo =
        '/home/Programs/Ruby/'+RUBY_VERSION+
        '/lib/ruby/gems/3.0.0/cache/gtk3-3.3.0/sample/misc/gnome-logo-icon.png',
      copyright = 
        'Copyright (©) 2021 by roebe',
      use_this_as_comment =
        'This shows how to use this widget.',
      array_authors       = [] # ['Author 1 <no1@foo.bar.com>', 'Author 2 <abc@foo.bar.com>']
    )
    a = Gtk::AboutDialog.new
    a.artists     = ['Artist 1 <no1@foo.bar.com>', 'Artist 2 <abc@foo.bar.com>']
    a.authors     = array_authors
    a.comments    = use_this_as_comment
    a.copyright   = copyright
    a.documenters = [
      'Documenter 1 <no1@foo.bar.com>',
      'Documenter 2 <no2@foo.bar.com>'
    ]
    a.license     = 'This program is licenced under the GPLv2.'
    if File.exist? use_this_logo
      a.logo      = GdkPixbuf::Pixbuf.new(file: use_this_logo)
    end
    a.name        = 'Gtk::AboutDialog sample'
    # ======================================================================= #
    # Credits for Translators:
    # ======================================================================= #
    a.translator_credits = "Written by shevy.\n"
    a.version       = '1.0.0'
    a.website       = 'https://rubygems.org/gems/gtk_paradise'
    a.website_label = 'https://rubygems.org/gems/gtk_paradise'
    return a
  end; self.instance_eval { alias return_about_dialog return_about_dialog_widget } # === Gtk.return_about_dialog

end