#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ButtonBox
#
# This seems to no longer exist in ruby-gtk4.
# =========================================================================== #
# require 'gtk_paradise/core_classes/button_box.rb'
# =========================================================================== #
require 'gtk_paradise/toplevel_methods/determine_which_gtk_version_is_in_use.rb'

unless Gtk.use_gtk4?

module Gtk

class ButtonBox # === Gtk::ButtonBox

  # ========================================================================= #
  # === do_expand
  # ========================================================================= #
  def do_expand
    self.layout = :expand
  end; alias expand do_expand # === expand

  # ========================================================================= #
  # === vertical_layout
  # ========================================================================= #
  def vertical_layout
    orientation_to_use = :vertical
    self.orientation = orientation_to_use
  end; alias is_vertical vertical_layout # === is_vertical

  # ========================================================================= #
  # === center
  #
  # This is simply a wrapper over .layout= to force the buttons to
  # be aligned in the center.
  # ========================================================================= #
  def center
    self.layout = :center
  end; alias do_center center # === do_center
    
end; end

end