#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# require 'gtk_paradise/core_classes/calendar.rb'
# =========================================================================== #
module Gtk

class Calendar # === Gtk::Calendar

  # ========================================================================= #
  # === on_day_selected
  #
  # This is a bit shorted than the .signal_connect() variant.
  # ========================================================================= #
  def on_day_selected(&block)
    signal_connect(:day_selected, &block)
  end

end

# =========================================================================== #
# === Gtk.calendar
# =========================================================================== #
def self.calendar
  ::Gtk::Calendar.new
end

end