#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::CellRendererText
# =========================================================================== #
# require 'gtk_paradise/core_classes/cell_renderer_text.rb'
# =========================================================================== #
module Gtk

class CellRendererText # === Gtk::CellRendererText

  # ========================================================================= #
  # === middle
  #
  # This method will align the cell-renderer into its middle.
  # ========================================================================= #
  def middle
    set_xalign(0.5)
  end; alias center              middle # === center
       alias align_to_the_middle middle # === align_to_the_middle

end

# =========================================================================== #
# === Gtk.create_cell_renderer_text
# =========================================================================== #
def Gtk.create_cell_renderer_text(
    background_colour = 'lavender',
    foreground_colour = 'black'
  )
  renderer = ::Gtk::CellRendererText.new
  renderer.set_property('background', background_colour)
  renderer.set_property('foreground', foreground_colour)
  return renderer
end; self.instance_eval { alias cell_renderer_text create_cell_renderer_text } # === Gtk.cell_renderer_text

# =========================================================================== #
# === Gtk.return_editable_cell_renderer_text
#
# This variant will return a cell-renderer that can be edited from the
# get go.
# =========================================================================== #
def self.return_editable_cell_renderer_text
  _ = ::Gtk::CellRendererText.new
  _.editable = true
  return _
end

# =========================================================================== #
# === Gtk.return_non_editable_cell_renderer_text
# =========================================================================== #
def self.return_non_editable_cell_renderer_text
  renderer = ::Gtk::CellRendererText.new
  renderer.editable = false
  return renderer
end

end