#!/usr/bin/ruby -w
# Encoding: UTF-8
# frozen_string_literal: true
# =========================================================================== #
# === Gtk::ComboBoxText
# =========================================================================== #
# require 'gtk_paradise/core_classes/combo_box_text.rb'
# =========================================================================== #
module Gtk

class ComboBoxText # === Gtk::ComboBoxText

  # ========================================================================= #
  # === model?
  #
  # This method has been verified to work in December 2023.
  # ========================================================================= #
  def model?
    model
  end; alias list_store? model? # === list_store?

  # ========================================================================= #
  # === find_and_try_to_select_this_entry
  #
  # This method will try to set the active-entry that is represented
  # by the ComboBoxText widget. In order for this to work, the
  # selection has to include the given element, of course.
  #
  # This method will silently fail if it can not find an appropriate
  # entry.
  #
  # This is currently incomplete.
  # ========================================================================= #
  def find_and_try_to_select_this_entry(this_entry = nil)
    if this_entry
    end
  end

  # ========================================================================= #
  # === selected?
  #
  # The upstream method-name for this is actually get_active_text(). This
  # can be found here:
  #
  #   https://gitlab.gnome.org/GNOME/gtk/blob/3.24.38/gtk/gtkcomboboxtext.c#L597
  #
  # ========================================================================= #
  def selected?
    active_text
  end; alias active_text? selected? # === active_text?
       alias text         selected? # === text
       alias text?        selected? # === text?
       alias entry?       selected? # === entry?

  # ========================================================================= #
  # === fill_up
  #
  # This method can be used to populate (or re-populate) a combo-box with
  # text entries.
  # ========================================================================= #
  def fill_up(*i)
    i = i.flatten.compact  # We don't want nil values here.
    i.each {|this_entry|
      this_entry = this_entry.to_s
      append_text(this_entry) if this_entry and !this_entry.empty?
    }
  end; alias fill_with                  fill_up # === fill_with
       alias populate                   fill_up # === populate
       alias populate_with_this_dataset fill_up # === populate_with_this_dataset
       alias populate_with_this_array   fill_up # === populate_with_this_array
       alias populate_with              fill_up # === populate_with

  # ========================================================================= #
  # === clear_old_datapoints
  # ========================================================================= #
  def clear_old_datapoints
    model.clear
  end; alias clear clear_old_datapoints # === clear

  # ========================================================================= #
  # === first_entry_is_active
  #
  # This method selects the first active entry in a ComboBoxText.
  # ========================================================================= #
  def first_entry_is_active
    set_active(0)
  end; alias first_is_active         first_entry_is_active # === first_is_active
       alias first_element_is_active first_entry_is_active # === first_element_is_active
       alias first_one_is_active     first_entry_is_active # === first_one_is_active
       alias first_entry_is_default  first_entry_is_active # === first_one_is_default
       alias first_is_default        first_entry_is_active # === first_is_default

  # ========================================================================= #
  # === this_entry_is_active
  # ========================================================================= #
  def this_entry_is_active(i)
    set_active(i.to_i)
  end

  # ========================================================================= #
  # === seven_per_row
  # ========================================================================= #
  def seven_per_row
    self.wrap_width = 7
  end

  # ========================================================================= #
  # === six_per_row
  # ========================================================================= #
  def six_per_row
    self.wrap_width = 6
  end

  # ========================================================================= #
  # === five_per_row
  # ========================================================================= #
  def five_per_row
    self.wrap_width = 5
  end

  # ========================================================================= #
  # === four_per_row
  # ========================================================================= #
  def four_per_row
    self.wrap_width = 4
  end

  # ========================================================================= #
  # === three_per_row
  # ========================================================================= #
  def three_per_row
    self.wrap_width = 3
  end

  # ========================================================================= #
  # === two_per_row
  # ========================================================================= #
  def two_per_row
    self.wrap_width = 2
  end

end; end